% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{measure}
\alias{measure}
\title{Plots the overlap of membership degrees in a matrix as a function of a
threshold.}
\usage{
measure(x, min = 0, max = 1, step = 0.1)
}
\arguments{
\item{x}{A matrix of membership degrees.}

\item{min}{Minimum threshold value for the plot (default is 0).}

\item{max}{Maximum threshold value for the plot (default is 1).}

\item{step}{Step size for the threshold values (default is 0.1).}
}
\value{
No return value, it plot the overlap as a function of the threshold.
}
\description{
Plots the overlap of membership degrees in a matrix as a function of a
threshold.
}
\examples{
membership_matrix <- matrix(runif(20), nrow = 5)
measure(membership_matrix, min = 0, max = 1, step = 0.2)
}
