% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental-features.R
\name{plot_model_curve}
\alias{plot_model_curve}
\title{Plot the model curve with predicted PAM values and confidence intervals.}
\usage{
plot_model_curve(
  cbass_dataset,
  grouping_properties = c("Site", "Condition", "Species", "Timepoint"),
  drm_formula = "Pam_value ~ Temperature",
  faceting_model = "Species ~ Site ~ Condition",
  size_text = 12,
  size_points = 2
)
}
\arguments{
\item{cbass_dataset}{A data frame containing the dataset to be processed.}

\item{grouping_properties}{A character vector of column names to be used for grouping. Default: c("Site", "Condition", "Species", "Timepoint").}

\item{drm_formula}{A formula object specifying the dose-response model. Default: "Pam_value ~ Temperature".}

\item{faceting_model}{A formula specifying the faceting of the plot. Default: "Species ~ Site ~ Condition".}

\item{size_text}{Default: 12. A formula specifying the faceting of the plot.}

\item{size_points}{Default: 2. A formula specifying the faceting of the plot.}
}
\value{
A ggplot object representing the model curve with predicted PAM values.
}
\description{
Plot the model curve with predicted PAM values and confidence intervals.
}
\examples{
data(cbass_dataset)

model_curve_plot <- plot_model_curve(cbass_dataset)
}
