% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-responce-curve.R
\name{get_predicted_pam_values}
\alias{get_predicted_pam_values}
\title{Get Predicted PAM Values}
\usage{
get_predicted_pam_values(models, temp_range)
}
\arguments{
\item{models}{A list of model objects representing PAM prediction models.}

\item{temp_range}{A numeric vector containing a sequence of temperature values for which PAM predictions will be generated.}
}
\value{
A data frame containing the predicted PAM values along with corresponding temperature values from the given temperature range.
}
\description{
This function takes a list of models and a temperature range, and generates predicted PAM (Pulse Amplitude Modulation) values based on the provided models and temperature range.
}
\examples{
# Load models and temperature range
# To load internal dataset that is provided with the R package
data("cbass_dataset")
cbass_dataset <- preprocess_dataset(cbass_dataset)
grouping_properties <- c("Site", "Condition", "Species", "Timepoint")
drm_formula <- "Pam_value ~ Temperature"

# Make list of model
models <- fit_drms(cbass_dataset, grouping_properties, drm_formula, is_curveid = FALSE)
temp_ranges <- define_temperature_ranges(cbass_dataset$Temperature, n = 100)

# Get predicted Pam_value values
predicted_pam <- get_predicted_pam_values(models, temp_ranges)

}
\seealso{
\code{\link{predict_temperature_values}}, \code{\link{transform_predictions_to_long_dataframe}}, \code{\link{define_temperature_ranges}}
\link{predict_temperature_values}
\link{transform_predictions_to_long_dataframe}
\link{define_temperature_ranges}
}
\keyword{PAM}
\keyword{model}
\keyword{predicted}
\keyword{range}
\keyword{temperature}
\keyword{values}
