% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radiation_parameters.R
\name{sr_tair_calculation}
\alias{sr_tair_calculation}
\title{Solar radiation data derived from air temperature differences}
\usage{
sr_tair_calculation(latitude, date, tmax, tmin, location_krs)
}
\arguments{
\item{latitude}{A dataframe with latitude in decimal degrees that you want to calculate the ra.}

\item{date}{A dataframe with the dates that you want to calculate the ra.}

\item{tmax}{A dataframe with Maximum daily air temperature (Celsius)}

\item{tmin}{A dataframe with Minimum daily air temperature (Celsius)}

\item{location_krs}{Adjustment coefficient based in location. Please decide between "coastal or "interior". If coastal the krs will be 0.19, if interior the krs will be 0.16.}
}
\value{
A data.frame object with solar radiation data
}
\description{
If global radiation is not measure at station, it can be estimated with this function.
}
\examples{
\dontrun{
sr_tair <- sr_tair_calculation(latitude, date, tmax, tmin, location_krs)
}
}
\author{
Roberto Filgueiras, Luan P. Venancio, Catariny C. Aleman and Fernando F. da Cunha
}
