% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sinesp_vde_data.R
\name{get_sinesp_vde_data}
\alias{get_sinesp_vde_data}
\title{get_sinesp_vde_data Function}
\usage{
get_sinesp_vde_data(
  state = "all",
  city = "all",
  year = "all",
  category = "all",
  typology = "all",
  granularity = "month"
)
}
\arguments{
\item{state}{State to be filtered. Character or vector. Default is "all".}

\item{city}{City to be filtered. Character or vector. Default is "all".}

\item{year}{Year(s) of the crime. Integer or vector. Default is "all".}

\item{category}{Crime category. Character or vector. Default is "all".}

\item{typology}{Crime typology (e.g., "Furto de veículo"). Character or vector. Default is "all".}

\item{granularity}{Level of temporal granularity: "year" or "month". Default is "month".}
}
\value{
A data frame with the filtered or summarized data.
}
\description{
This function collects criminal data from the SINESP VDE database (2015–2024).
It supports filtering by state, city, year, crime category and typology.
}
\examples{
\donttest{
dados <- get_sinesp_vde_data(state = "SP", year = 2020:2022)
}
}
