% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_LnLCompactness.R
\name{BP_LnLCompactness}
\alias{BP_LnLCompactness}
\title{Estimation of the likelihood of a bone section}
\usage{
BP_LnLCompactness(
  par,
  bone = NULL,
  data_m = NULL,
  data_nm = NULL,
  distance.center = NULL,
  fixed.parameters = NULL,
  analysis = 1,
  sign = -1
)
}
\arguments{
\item{par}{Parameters of the model}

\item{bone}{The bone image to be used}

\item{data_m}{Number of mineralized pixels}

\item{data_nm}{Number of non-mineralized pixels}

\item{distance.center}{Distances to the center}

\item{fixed.parameters}{Fixed parameters of the model}

\item{analysis}{Name or rank of analysis}

\item{sign}{The likelihood if multiplied by sign (-1 or +1) to return -Ln L or Ln L}
}
\value{
The -Ln L
}
\description{
Estimation of the compactness of a bone section.
}
\details{
BP_LnLCompactness estimates likelihood of model of a bone section
}
\examples{
\dontrun{
# Not run:
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone)
 bone <- BP_DetectForeground(bone=bone)
 bone <- BP_DetectCenters(bone=bone)
 bone <- BP_EstimateCompactness(bone)
 plot(bone)
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitBayesianPeriodicCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLPeriodicCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
