% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioM2.R
\name{FindParaModule}
\alias{FindParaModule}
\title{Find suitable parameters for partitioning pathways modules}
\usage{
FindParaModule(
  pathways_matrix = NULL,
  control_label = 0,
  minModuleSize = seq(10, 20, 5),
  mergeCutHeight = seq(0, 0.3, 0.1),
  minModuleNum = 5,
  power = NULL,
  exact = TRUE,
  ancestor_anno = NULL
)
}
\arguments{
\item{pathways_matrix}{A pathway matrix generated by the BioM2( target='pathways') function.}

\item{control_label}{The label of the control group ( A single number, factor, or character )}

\item{minModuleSize}{minimum module size for module detection. Detail for WGCNA::blockwiseModules()}

\item{mergeCutHeight}{dendrogram cut height for module merging. Detail for WGCNA::blockwiseModules()}

\item{minModuleNum}{Minimum total number of modules detected}

\item{power}{soft-thresholding power for network construction. Detail for WGCNA::blockwiseModules()}

\item{exact}{Whether to divide GO pathways more accurately (work when ancestor_anno=NULL)}

\item{ancestor_anno}{Annotations for ancestral relationships (like data('GO_Ancestor') )}
}
\value{
A list containing recommended parameters
}
\description{
Find suitable parameters for partitioning pathways modules
}
