% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bevimed_m}
\alias{bevimed_m}
\title{Perform inference under model gamma = 1 conditional on mode of inheritance}
\usage{
bevimed_m(
  y,
  G,
  min_ac = 1L,
  G2 = NULL,
  tau_shape = c(1, 1),
  pi_shape = c(6, 1),
  omega_shape = if (max(min_ac) == 1L) c(2, 8) else c(2, 2),
  samples_per_chain = 1000,
  stop_early = FALSE,
  blocks = 5,
  burn = as.integer(samples_per_chain/10),
  temperatures = (0:6/6)^2,
  tune_temps = 0,
  vec_sums = FALSE,
  return_z_trace = TRUE,
  return_x_trace = TRUE,
  raw_only = FALSE,
  swaps = as.integer(length(temperatures)/2),
  optimise_z0 = FALSE,
  tune_omega_and_phi_proposal_sd = FALSE,
  tune_block_size = 100,
  variant_weights = NULL,
  standardise_weights = TRUE,
  log_phi_mean = -0.15,
  log_phi_sd = sqrt(0.3),
  tandem_variant_updates = if (max(min_ac) == 1) 0 else min(sum(y), ncol(G)),
  ...
)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one row per individual and one column per variant.}

\item{min_ac}{Integer vector with a length equalling the number of individuals or length \code{1} (in which case the given value is used for all individuals) giving the minimum number of alleles at pathogenic variant sites each individual requires in order to classify as having a `pathogenic allele configuration'. Thus, this parameter encodes the mode of inheritance. For instance, setting this parameter to \code{1} corresponds to dominant inheritance. If there are differences in ploidy between individuals in the locus, it is necessary to set it on an sample level basis - e.g. to ensure sex is accounted for if the locus lies on the X chromosome.}

\item{G2}{For when phased genotype data is available, corresponding matrix of genotypes for the second haplotype (defaults to \code{NULL}, if provided BeviMed is run in phased mode where allele configurations are only pathogenic when all haplotypes harbour a pathogenic allele under recessive recessive inheritance).}

\item{tau_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with non-pathogenic variant combinations (i.e. they have less than \code{min_ac} variants.}

\item{pi_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with pathogenic variant combinations (i.e. they have at least \code{min_ac} variants.}

\item{omega_shape}{Beta shape hyper-priors for prior on rate of pathogenicity amongst variants.}

\item{samples_per_chain}{Number of samples to draw from each chain.}

\item{stop_early}{Logical value determining whether to attempt to stop the sampling as soon as certain conditions are met (i.e. either the estimated marginal log likelihood lies within a certain confidence interval, or we are sufficiently confidence that the log Bayes factor against of model gamma = 1 over model gamma = 0 is sufficiently low).}

\item{blocks}{Maximum number of blocks of \code{samples_per_chain} samples to draw before either the confidence interval for the marginal likelihood under the model gamma = 1 is sufficiently small or terminating the sampling. This parameter is ignored if unless \code{stop_early==TRUE}.}

\item{burn}{Number of samples to drop from the start of the chain.}

\item{temperatures}{Numeric vector of temperatures of power posteriors. One chain will be created for each element of the vector at the corresponding temperature.}

\item{tune_temps}{Integer value - if greater than 0, the \code{temperatures} argument is ignored, and instead \code{tune_temps} tuned temperatures are used instead.}

\item{vec_sums}{Logical value determining whether to calculate vector summary statistics.}

\item{return_z_trace}{Logical value determining whether to store the z-vectors for each chain, which uses alot of memory, particularly if \code{samples_per_chain}, k and \code{length(temperatures)} are large.}

\item{return_x_trace}{Logical value determining whether to store the x variable determined by success samples of z. Potentially uses alot of memory, particularly if \code{samples_per_chain}, k and \code{length(temperatures)} are large.}

\item{raw_only}{Logical value determining whether to return raw output of MCMC routine only.}

\item{swaps}{Number of swaps between adjacent tempered chains to perform per update cycle.}

\item{optimise_z0}{Logical value determining whether to use a simulated annealing optimisation run to tune the initial values of \code{z}.}

\item{tune_omega_and_phi_proposal_sd}{Logical value determining whether the proposal SDs of the Metropolis-Hastings estimated parameters should be tuned for a target acceptance range.}

\item{tune_block_size}{Integer value giving number of samples to draw when estimatating the acceptance rate of the omega/phi proposals.}

\item{variant_weights}{Vector of log-odds off-sets for rates of pathogenicity of individual variants relative to the global rate, omega.}

\item{standardise_weights}{Boolean value determining whether weights should be standardised by subtracting their mean and dividing by their sample standard deviation. If \code{FALSE}, weights are untransformed.}

\item{log_phi_mean}{Mean for normal prior on scaling factor phi.}

\item{log_phi_sd}{SD for normal prior on scaling factor phi. Setting to 0 causes the weights to be fixed and not estimated.}

\item{tandem_variant_updates}{Number of tandem variant updates to make per update cycle.}

\item{...}{Other arguments to be passed to \code{\link{stop_chain}} and/or \code{\link{tune_proposal_sds}}.}
}
\value{
An object of class \code{BeviMed_m}.
}
\description{
Sample from posterior distribution of parameters under model gamma = 1 and conditional on mode of inheritance, set via the \code{min_ac} argument.
}
\details{
A \code{BeviMed_m} object is a list containing elements:
\itemize{
\item `parameters': a list containing arguments used in the function call, including the adjusted weights used in the inference in the `c_weights' slot,
\item `traces': a list of traces of model parameters from all MCMC chains for each parameter. Parameters sampled are z, omega, phi and x (the indicator of having a pathogenic configuration of alleles). The list of traces is named by parameter name, and each is a matrix where the rows correspond to samples. $z has k columns for each temperature, with the samples from the true posterior (i.e. with temperature equal to 1) of z corresponding to the final k columns. Likewise, the true posterior is given by the final column for the traces of phi and omega. The trace of x is only given for temperature equal to 1 to reduce memory usage.
\item `final': a list named by model parameter giving the final sample of each,
\item `swaps': a list with an element named `accept' which is a logical vector whose ith element indicates whether the ith swap between adjacent tempered chains was accepted or not, and an element named `at_temperature`, an integer vector whose ith element indicates which pair of consecutive temperatures was the ith to be proposed for swapping (giving the lowest one). 
}
}
\references{
Greene et al., A Fast Association Test for Identifying Pathogenic Variants Involved in Rare Diseases, The American Journal of Human Genetics (2017), http://dx.doi.org/10.1016/j.ajhg.2017.05.015.
}
\seealso{
\code{\link{bevimed_m}}, \code{\link{prob_association_m}}
}
