% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activations}
\alias{activations}
\alias{id_activations}
\title{Identify field activations}
\usage{
activations(
  x,
  Bayes = TRUE,
  gamma = NULL,
  alpha = 0.05,
  correction = c("FWER", "FDR", "none"),
  fields = NULL,
  sessions = NULL,
  verbose = 1
)

id_activations(
  x,
  Bayes = TRUE,
  gamma = NULL,
  alpha = 0.05,
  correction = c("FWER", "FDR", "none"),
  fields = NULL,
  sessions = NULL,
  verbose = 1
)
}
\arguments{
\item{x}{Result of \code{BayesGLM} or \code{fit_bayesglm} model
call, of class \code{"BGLM"} or \code{"fit_bglm"}.}

\item{Bayes}{Use spatial Bayesian modeling to identify activations based on
the joint posterior distribution? Default: \code{TRUE}. If \code{FALSE},
activations will be based on classical (massive univariate) GLM model, with
multiple comparisons correction (see \code{correction}). Note that \code{TRUE}
is only applicable if \code{x} includes Bayesian results (i.e.
\code{x <- BayesGLM(..., Bayes = TRUE)} was run.)}

\item{gamma}{Activation threshold, for example \code{1} for 1 percent
signal change if \code{scale_BOLD=="mean"} during model estimation. Setting
a \code{gamma} is required for the Bayesian method; \code{NULL}
(default) will use a \code{gamma} of zero for the classical method.}

\item{alpha}{Significance level for inference. Default: \code{0.05}.}

\item{correction}{For the classical method only: Type of multiple comparisons
correction: \code{"FWER"} (Bonferroni correction, the default), \code{"FDR"}
(Benjamini Hochberg), or \code{"none"}.}

\item{fields}{The field(s) to identify activations for. Give either the name(s)
as a character vector, or the numerical indices. If \code{NULL} (default),
analyze all fields.}

\item{sessions}{The session(s) to identify activations for. Give either the
name(s) as a character vector, or the numerical indices. If \code{NULL}
(default), analyze the first session.}

\item{verbose}{\code{1} (default) to print occasional updates during model
computation; \code{2} for occasional updates as well as running INLA in
verbose mode (if \code{Bayes}), or \code{0} for no printed updates.}
}
\value{
An \code{"act_BGLM"} or \code{"act_fit_bglm"} object, a
list which indicates the activated locations along with related information.
}
\description{
Identify areas of activation for each field from the result of \code{BayesGLM}
or \code{fit_bayesglm}.
}
