% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.bin.test}
\alias{BF10.bin.test}
\title{Bayes factor for a Bayesian one-proportion test}
\usage{
BF10.bin.test(x, n, alpha, beta, location, scale, model, hypothesis, e = NULL)
}
\arguments{
\item{x}{Observed number of successes.}

\item{n}{Sample size.}

\item{alpha}{Parameter for the analysis beta prior under the alternative hypothesis.}

\item{beta}{Parameter for the analysis beta prior under the alternative hypothesis.}

\item{location}{Null proportion value.}

\item{scale}{Scale parameter for the analysis prior (if applicable, e.g., for Moment prior).}

\item{model}{Statistical model of the analysis prior under the alternative hypothesis: beta prior (\code{"beta"}) or Moment prior (\code{"Moment"}).}

\item{hypothesis}{The hypothesis being tested: two-sided (\code{"!="}), right-sided (\code{">"}), or left-sided (\code{"<"}).}

\item{e}{Optional numeric vector specifying bounds for an interval null; used if interval BF is calculated.}
}
\value{
The Bayes factor (BF10) for the one-proportion test.
}
\description{
Calculate the Bayes factor (BF10) for a test of a single proportion, either against a point null or an interval null hypothesis.
}
\examples{
BF10.bin.test(
  x = 12,
  n = 50,
  alpha = 2,
  beta = 3,
  location = 0.5,
  scale = 1,
  model = "beta",
  hypothesis = "!="
)
}
