% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_fn.R
\name{summary_fn}
\alias{summary_fn}
\title{A function to summarise the fitted mortality rates and parameters of stochastic mortality models}
\usage{
summary_fn(result, pred_int = 0.95)
}
\arguments{
\item{result}{object of type either "fit_result"  or "BayesMoFo".}

\item{pred_int}{A numeric value (between 0 and 1) specifying the credible level of uncertainty bands. Default is \code{pred_int=0.95} (\eqn{95\%} intervals).}
}
\value{
A list with components:
rates_summary=list(mean=rates_mean,std=rates_std),rates_pn=list(lower=rates_lower,median=rates_median,upper=rates_upper),param_summary=list(mean=param_mean,std=param_std),param_pn=param_pn
\describe{
\item{\code{rates_summary}}{A list containing 2 components, respectively called "mean" (\code{$rates_summary$mean}) and "std" (\code{$rates_summary$std}). Both return a 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years), with the former giving posterior means of fitted mortality rates while the latter giving standard errors.}
\item{\code{rates_pn}}{A list containing 3 components, respectively called "lower" (\code{$rates_pn$lower}), "median" (\code{$rates_pn$median}), and "upper" (\code{$rates_pn$upper}). All return a 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years), representing the respective percentiles for the fitted mortality rates.}
\item{\code{param_summary}}{A list containing 2 components, respectively called "mean" (\code{$param_summary$mean}) and "std" (\code{$param_summary$std}). Both return a 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years), with the former giving posterior means of fitted parameters while the latter giving standard errors.}
\item{\code{param_pn}}{A 2-dimensional matrix containing percentiles of fitted parameters.}
}
}
\description{
Provide summaries (means, standard errors, percentiles) of the fitted mortality rates and parameters, derived using posterior samples stored in "fit_result" object.
}
\examples{
\donttest{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit any mortality model
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,n_iter=1000,models="APCI")

#default summary
summary_runBayesMoFo<-summary_fn(runBayesMoFo_result)

#mean of fitted mortality rates 
summary_runBayesMoFo$rates_summary$mean

#standard errors of fitted mortality rates 
summary_runBayesMoFo$rates_summary$std

#97.5th percentile of fitted mortality rates 
summary_runBayesMoFo$rates_pn$upper

#mean of fitted parameters 
summary_runBayesMoFo$param_summary$mean

#standard errors of fitted parameters 
summary_runBayesMoFo$param_summary$std

#97.5th percentile of fitted parameters 
summary_runBayesMoFo$param_pn[,"upper"]
}
}
\concept{credible intervals}
\concept{death rates}
\concept{parameters}
\concept{summary}
\keyword{statistics}
