% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_utility.R
\name{local_poly_helper}
\alias{local_poly_helper}
\title{Constructing and evaluating the local O-spline basis (design matrix)}
\usage{
local_poly_helper(knots, refined_x, p = 2, neg_sign_order = 0)
}
\arguments{
\item{knots}{A vector of knots used to construct the O-spline basis, first knot should be viewed as "0",
the reference starting location. These k knots will define (k-1) basis function in total.}

\item{refined_x}{A vector of locations to evaluate the O-spline basis}

\item{p}{An integer value indicates the order of smoothness}

\item{neg_sign_order}{An integer value N such that D = ((-1)^N)*D for the splines at negative knots. Default is 0.}
}
\value{
A matrix with i,j component being the value of jth basis function
value at ith element of refined_x, the ncol should equal to number of knots minus 1, and nrow
should equal to the number of elements in refined_x.
}
\description{
Constructing and evaluating the local O-spline basis (design matrix)
}
\examples{
local_poly_helper(knots = c(0, 0.2, 0.4, 0.6, 0.8), refined_x = seq(0, 0.8, by = 0.1), p = 2)
}
