% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_post_fit.R
\name{compute_post_fun_iwp}
\alias{compute_post_fun_iwp}
\title{Computing the posterior samples of the function or its derivative using the posterior samples
of the basis coefficients for iwp}
\usage{
compute_post_fun_iwp(
  samps,
  global_samps = NULL,
  knots,
  refined_x,
  p,
  degree = 0,
  intercept_samps = NULL
)
}
\arguments{
\item{samps}{A matrix that consists of posterior samples for the O-spline basis coefficients. Each column
represents a particular sample of coefficients, and each row is associated with one basis function. This can
be extracted using `sample_marginal` function from `aghq` package.}

\item{global_samps}{A matrix that consists of posterior samples for the global basis coefficients. If NULL,
assume there will be no global polynomials and the boundary conditions are exactly zero.}

\item{knots}{A vector of knots used to construct the O-spline basis, first knot should be viewed as "0",
the reference starting location. These k knots will define (k-1) basis function in total.}

\item{refined_x}{A vector of locations to evaluate the O-spline basis}

\item{p}{An integer value indicates the order of smoothness}

\item{degree}{The order of the derivative to take, if zero, implies to consider the function itself.}

\item{intercept_samps}{A matrix that consists of posterior samples for the intercept parameter. If NULL, assume
the function evaluated at zero is zero.}
}
\value{
A data.frame that contains different samples of the function or its derivative, with the first column
being the locations of evaluations x = refined_x.
}
\description{
Computing the posterior samples of the function or its derivative using the posterior samples
of the basis coefficients for iwp
}
\examples{
knots <- c(0, 0.2, 0.4, 0.6)
samps <- matrix(rnorm(n = (3 * 10)), ncol = 10)
result <- compute_post_fun_iwp(samps = samps, knots = knots, refined_x = seq(0, 1, by = 0.1), p = 2)
plot(result[, 2] ~ result$x, type = "l", ylim = c(-0.3, 0.3))
for (i in 1:9) {
  lines(result[, (i + 1)] ~ result$x, lty = "dashed", ylim = c(-0.1, 0.1))
}
global_samps <- matrix(rnorm(n = (2 * 10), sd = 0.1), ncol = 10)
}
