% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{Bayes_test}
\alias{Bayes_test}
\title{Bayesian inference for survival analysis}
\usage{
Bayes_test(data, alpha, beta, test, threshold, type, pred, diagnosis = FALSE)
}
\arguments{
\item{data}{Matrix. The data contains both survival time and event status.}

\item{alpha}{Numerical. Gamma distribution alpha parameter.}

\item{beta}{Numerical. Gamma distribution beta parameter (rate = 1/scale).}

\item{test}{Categorical. Three types of hypothesis includes "greater", "less", or "two_sided".}

\item{threshold}{Numerical. The value tested against hypothesis or evidence.}

\item{type}{Categorical. The types of Bayesian inference include "Posterior" for estimation of parameters or "Predictive" for predicted survival rate.}

\item{pred}{Numerical. The time point for predicted survival rate, for example, 2 years, or 5 years survival probability.}

\item{diagnosis}{Logical. If \code{diagnosis == TRUE}, the Bayes factor is calculated, and the formulation of Bayesian factors is given in details.}
}
\value{
Bayesian test provide \code{mean}, \code{sd}, \code{CI}, \code{z_score}, \code{prob}, and \code{bf}.

\code{mean} Posterior mean is estimated by calculating the mean of MCMC outputs.

\code{sd} Posterior standard deviation is estimated as the standard deviation of MCMC outputs.

\code{CI}Summary statistics provides the credible intervals and specific quantile.

\code{z_score} Standardized test of statistics is calculated based on MCMC outputs. For example,

\deqn{ \frac{\hat{\lambda} - \lambda_0}{SD( \hat{\lambda} )} \text{ or } \frac{ \hat{S} - S_0}{SD( \hat{S} )},}

where \eqn{\hat{\lambda}} is the estimated posterior mean of hazard rate, and \eqn{\hat{S}} is the predicted survival probability. Both \eqn{\lambda_0} and \eqn{S_0} are threshold used for test against hypothesis or evidence.

\code{prob} Posterior probability: \eqn{P(\hat{\lambda} > \lambda_0)} if \code{test} is "greater", \eqn{P(\hat{\lambda} \le \lambda_0)} if \code{test} is "less", and \eqn{2 min( P(\hat{\lambda} > \lambda_0),P(\hat{\lambda} \le \lambda_0))} if \code{test} is "two-sided".

\code{bf} Bayes Factor is calculated if \code{diagnosis = TRUE}, and the comparison model is non-informative prior, Jeffreys prior, \eqn{\pi \propto 1/\lambda}.
}
\description{
\code{Bayes_test} conduct hypothesis test through Bayesian survival model
}
\examples{
data <- Simulate_Enroll(n = c(50,20,20), lambda = 0.03,
                        event = 0.1, M = 1, group = 3,
                        maxt = 5, accrual = 3, censor = 0.9,
                        followup = 2,partition = "Uneven")
test <- Bayes_test(data, alpha = 3, beta = 82, test = "greater",
                   pred = 2, threshold = 0.9, type = "Predictive",
                   diagnosis = TRUE)
print(test)
}
\references{
Jeffreys, H. (1946). An invariant form for the prior probability in estimation problems. Proceedings of the Royal Society of London. Series A. Mathematical and Physical Sciences, 186(1007), 453-461.

Kass, R. E., & Raftery, A. E. (1995). Bayes factors. Journal of the american statistical association, 90(430), 773-795.
}
