% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{BayesAT}
\alias{BayesAT}
\alias{summary.BayesAT}
\alias{plot.BayesAT}
\title{Bayesian adaptive trial interim analysis}
\usage{
BayesAT(
  data,
  D,
  stage,
  threshold,
  start,
  objective,
  alpha,
  beta,
  boundary = NULL
)
}
\arguments{
\item{data}{Matrix. The data contains both survival time and event status.}

\item{D}{Numerical. The duration of interim analysis, matching the length of enrollment time.}

\item{stage}{Integer. Numbers of interim analysis stages.}

\item{threshold}{Numerical. The value tested against hypothesis or evidence.}

\item{start}{Numerical. The time point when the interim analysis starts.}

\item{objective}{Numerical. The time point for predicted survival rate, for example, 2 years, or 5 years survival probability.}

\item{alpha}{Numerical. Gamma distribution alpha parameter.}

\item{beta}{Numerical. Gamma distribution beta parameter (rate = 1/scale).}

\item{boundary}{The stopping criterion for interim analysis, and the default sets at 5\% significance level and calculate quantiles by \code{qnorm()} for each stages.}
}
\value{
Interim analysis reporting Bayesian adaptive trial results.

If there is one data set applied to \code{BayesAT}, the result will provide a table containing:

\verb{Upper bound} can be used as stopping criterion for efficacy;

\verb{Lower bound} can be used as stopping criterion for futility;

\verb{Z score} Z statistic is calculated based on the predicted survival probability:

\deqn{\frac{\hat{S} - S_0}{SD( \hat{S} )}}

with predicted mean survival rate \eqn{\hat{S}} and test evidence or threshold \eqn{S_0}.

\verb{Efficacy Prob} and \verb{Futility Prob} Predictive probability measures the efficacy or futility, such as \eqn{P(\hat{S} > \text{Efficacy})} and \eqn{P(\hat{S} < \text{Futility})}.

\code{Efficacy} and \code{Futility} indicate the interim analysis results: \code{+} means the trial reach the stopping criterion, otherwise it is \code{-}.
}
\description{
\code{BayesAT} conducts Bayesian adaptive trials through multiple-stage interim analysis.
}
\examples{
data <- Simulate_Enroll(n = c(30,20,20,15,30), lambda = 0.03,
                        event = 0.1, M = 3, group = 5, maxt = 5,
                        accrual = 3,  censor = 0.9, followup = 2,
                        partition = "Uneven")
## assign patients in each group analyzed at each stage of time points
IA <- BayesAT(data,D = 3,stage = 5,threshold = 0.9, start = 1.5,
              objective = 2, alpha = 3, beta = 82)
summary(IA)
plot(IA)
}
