% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceResultsExperimentsParallel.R
\name{reduceResultsExperimentsParallel}
\alias{reduceResultsExperimentsParallel}
\title{Reduce very many results in parallel.}
\usage{
reduceResultsExperimentsParallel(
  reg,
  ids,
  part = NA_character_,
  fun,
  ...,
  timeout = 604800L,
  njobs = 20L,
  strings.as.factors = FALSE,
  impute.val,
  apply.on.missing = FALSE,
  progressbar = TRUE
)
}
\arguments{
\item{reg}{[\code{\link{ExperimentRegistry}}]\cr
Registry.}

\item{ids}{[\code{integer}]\cr
Ids of selected experiments.
Default is all jobs for which results are available.}

\item{part}{[\code{character}]
Only useful for multiple result files, then defines which result file part(s) should be loaded.
\code{NA} means all parts are loaded, which is the default.}

\item{fun}{[\code{function(job, res, ...)}]\cr
Function to collect values from \code{job} and result \code{res} object, the latter from stored result file.
Must return a named object which can be coerced to a \code{data.frame} (e.g. a \code{list}).
Default is a function that simply returns \code{res} which may or may not work, depending on the type
of \code{res}. We recommend to always return a named list.}

\item{...}{[any]\cr
Additional arguments to \code{fun}.}

\item{timeout}{[\code{integer(1)}]
Seconds to wait for completion. Passed to \code{\link[BatchJobs]{waitForJobs}}.
Default is 648400 (one week).}

\item{njobs}{[\code{integer(1)}]
Number of parallel jobs to create.
Default is 20.}

\item{strings.as.factors}{[\code{logical(1)}]
Should all character columns in result be converted to factors?
Default is \code{FALSE}.}

\item{impute.val}{[\code{named list}]\cr
If not missing, the value of \code{impute.val} is used as a replacement for the
return value of function \code{fun} on missing results. An empty list is allowed.}

\item{apply.on.missing}{[\code{logical(1)}]\cr
Apply the function on jobs with missing results? The argument \dQuote{res} will be \code{NULL}
and must be handled in the function.
This argument has no effect if \code{impute.val} is set.
Default ist \code{FALSE}.}

\item{progressbar}{[\code{logical(1)}]\cr
Set to \code{FALSE} to disable the progress bar.
To disable all progress bars, see \code{\link[BBmisc]{makeProgressBar}}.}
}
\value{
[\code{data.frame}]. Aggregated results, containing problem and algorithm paramaters and collected values.
}
\description{
Basically the same as \code{\link{reduceResultsExperiments}} but creates a few (hopefully short) jobs
to reduce the results in parallel. The function internally calls \code{\link[BatchJobs]{batchMapQuick}},
does \dQuote{busy-waiting} till
all jobs are done and cleans all temporary files up.

The rows are ordered as \code{ids} and named with \code{ids}, so one can easily index them.
}
