% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bme_map.R
\name{bme_map}
\alias{bme_map}
\title{Create BMEmapping object}
\usage{
bme_map(ch, cs, zh, a, b)
}
\arguments{
\item{ch}{A two-column matrix of coordinates for hard data locations.}

\item{cs}{A two-column matrix of coordinates for soft data locations.}

\item{zh}{A numeric vector of observed values at the hard data locations.}

\item{a}{A numeric vector of lower bounds for soft interval data.}

\item{b}{A numeric vector of upper bounds for soft interval data.}
}
\value{
A list containing the input arguments \code{ch}, \code{cs},
\code{zh}, \code{a}, and \code{b}, with class \code{"BMEmapping"}.
}
\description{
Function that creates BMEmapping objects; objects that hold all the data
information necessary for BME interpolation.
}
\examples{
ch <- matrix(c(1, 2, 3, 4), ncol = 2)
cs <- matrix(c(5, 6, 7, 8), ncol = 2)
zh <- c(10, 20)
a <- c(8, 9)
b <- c(12, 14)
obj <- bme_map(ch, cs, zh, a, b)
class(obj)  # "BMEmapping"

}
