% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_traitbyspecies}
\alias{BIEN_trait_traitbyspecies}
\title{Download trait data for given species and trait.}
\usage{
BIEN_trait_traitbyspecies(
  species,
  trait,
  all.taxonomy = FALSE,
  political.boundaries = FALSE,
  source.citation = FALSE,
  ...
)
}
\arguments{
\item{species}{A single species or a vector of species.}

\item{trait}{A single trait or a vector of traits.}

\item{all.taxonomy}{Should full taxonomic information and TNRS output be returned?  Default is FALSE.}

\item{political.boundaries}{Should political boundary information (country, state, etc.) be returned?  Default is FALSE.}

\item{source.citation}{Should readable source information be downloaded for each record?  Note that \code{\link{BIEN_metadata_citation}} may be more useful.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe of all data matching the specified trait(s) and species.
}
\description{
BIEN_trait_traitbyspecies extracts entries that contain the specified species and trait(s).
}
\note{
Trait spelling needs to be exact and case-sensitive, see \code{\link{BIEN_trait_list}} for a list of traits.
}
\examples{
\dontrun{
BIEN_trait_traitbyspecies(trait = "whole plant height", species = "Carex capitata")
trait_vector<-c("whole plant height", "leaf area")
species_vector<-c("Carex capitata","Betula nana")
BIEN_trait_traitbyspecies(trait=trait_vector,species=species_vector)}
}
\seealso{
Other trait functions: 
\code{\link{BIEN_trait_country}()},
\code{\link{BIEN_trait_family}()},
\code{\link{BIEN_trait_genus}()},
\code{\link{BIEN_trait_list}()},
\code{\link{BIEN_trait_mean}()},
\code{\link{BIEN_trait_species}()},
\code{\link{BIEN_trait_trait}()},
\code{\link{BIEN_trait_traitbyfamily}()},
\code{\link{BIEN_trait_traitbygenus}()},
\code{\link{BIEN_trait_traits_per_species}()}
}
\concept{trait functions}
