% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_phylogeny_label_nodes}
\alias{BIEN_phylogeny_label_nodes}
\title{Label nodes on a phylogeny}
\usage{
BIEN_phylogeny_label_nodes(
  phylogeny,
  family = TRUE,
  genus = FALSE,
  other_taxa = NULL,
  ...
)
}
\arguments{
\item{phylogeny}{A single phylogeny.}

\item{family}{Should family-level nodes be labeled?  Default is TRUE.}

\item{genus}{Should genus-level nodes be labeled?  Default is FALSE.  Overwrites family-level nodes where a family contains a single genera.}

\item{other_taxa}{A dataframe containing two columns: 1) the taxa to be labelled; 2) the species associated with each taxon.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Input phylogeny with labeled nodes.
}
\description{
BIEN_phylogeny_label_nodes will label the nodes on a phylogeny based on either the BIEN taxonomy or user-supplied taxa.
}
\note{
Information on the construction of the BIEN phylogenies is available online at https://bien.nceas.ucsb.edu/bien/biendata/bien-2/phylogeny/
}
\examples{
\dontrun{
phylogeny<-BIEN_phylogeny_conservative()

phylogeny<-drop.tip(phy = phylogeny,tip = 101:length(phylogeny$tip.label))
plot.phylo(x = phylogeny,show.tip.label = FALSE)

fam_nodes<-BIEN_phylogeny_label_nodes(phylogeny = phylogeny,family = TRUE)
plot.phylo(x = fam_nodes,show.tip.label = FALSE, show.node.label = TRUE)

gen_nodes<-BIEN_phylogeny_label_nodes(phylogeny = phylogeny, family = FALSE, genus = TRUE)
plot.phylo(x = gen_nodes, show.tip.label = FALSE, show.node.label = TRUE)

other_taxa <- as.data.frame(matrix(nrow = 10,ncol = 2))
colnames(other_taxa)<-c("taxon","species")
other_taxa$taxon[1:5]<-"A" #Randomly assign a few species to taxon A
other_taxa$taxon[6:10]<-"B" #Randomly assign a few species to taxon B
tax_nodes <- 
 BIEN_phylogeny_label_nodes(phylogeny = phylogeny,
                            family = FALSE, genus = FALSE, other_taxa = other_taxa)
plot.phylo(x = tax_nodes,show.tip.label = FALSE,show.node.label = TRUE)}
}
\seealso{
Other phylogeny functions: 
\code{\link{BIEN_phylogeny_complete}()},
\code{\link{BIEN_phylogeny_conservative}()}
}
\concept{phylogeny functions}
