% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{bertopic_visualize_distribution}
\alias{bertopic_visualize_distribution}
\title{Visualize topic probability distribution}
\usage{
bertopic_visualize_distribution(
  model,
  probs,
  min_probability = NULL,
  custom_labels = FALSE,
  title = NULL,
  width = NULL,
  height = NULL,
  file = NULL
)
}
\arguments{
\item{model}{A "bertopic_r" model.}

\item{probs}{Numeric vector of topic probabilities for a single document.}

\item{min_probability}{Optional numeric scalar. If provided, only
probabilities greater than this value are visualized (forwarded to
\code{min_probability} in Python).}

\item{custom_labels}{Logical or character scalar. If logical, whether to
use custom topic labels as set via \code{set_topic_labels()}. If character,
selects labels from other aspects (e.g., "Aspect1").}

\item{title}{Optional character plot title.}

\item{width, height}{Optional integer figure width/height in pixels.}

\item{file}{Optional HTML output path. If NULL, an \code{htmltools::HTML}
object is returned.}
}
\value{
If \code{file} is NULL, an \code{htmltools::HTML} object. Otherwise, the
normalized file path is returned invisibly.
}
\description{
Wrapper around Python \code{BERTopic.visualize_distribution()}. This function
takes a single document's topic probability vector (e.g., one row from
\code{probs}) and returns an interactive Plotly figure as HTML or writes it
to disk.
}
