% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-dosage.R
\name{convert.alleles.to.pgs.dosage}
\alias{convert.alleles.to.pgs.dosage}
\title{Convert alleles to dosage}
\usage{
convert.alleles.to.pgs.dosage(called.alleles, risk.alleles)
}
\arguments{
\item{called.alleles}{A vector of genotypes in allelic notation separated by a slash or pipe.}

\item{risk.alleles}{A vector of risk alleles from a polygenic score corresponding to each genotype (by locus) in called.alleles.}
}
\value{
A vector of dosages corresponding to each genotype in called.alleles. Hemizygous genotypes (one allele e.g. 'A') are counted as 1.
}
\description{
Convert genotype calls in the form of witten out alleles (e.g. 'A/T') to dosages (0, 1, 2) based on provided risk alleles from a PGS.
}
\examples{
called.alleles <- c('A/A', 'A/T', 'T/T');
risk.alleles <- c('T', 'T', 'T');
convert.alleles.to.pgs.dosage(called.alleles, risk.alleles);
}
