% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Band_Depth_Distance.R
\name{dxy_bands}
\alias{dxy_bands}
\title{Band depth distance between 2 time series given a set of bands}
\usage{
dxy_bands(allbands, x, y)
}
\arguments{
\item{allbands}{a list with two elements the lowerbounds of all (n)(n-1)/2
pairs and the upperbounds of the pairwise bands.}

\item{x}{A vector  representing a univariate time series}

\item{y}{A vector  representing a univariate time series}
}
\value{
A non-negative value representing the distance between two time
series, based on the concept of band depth.
}
\description{
Distance based on a depth concept, given a set of bands a modified Jaccard
measure is compute between the sets of indices that two series share,
the Jaccard distances then are averaged over all informative bands.
}
\examples{
X=matrix( rnorm(200), ncol=10  )
M=all_bands(X)
dxy_bands(M,X[,1],X[,2] )

}
\seealso{
Band Depth Clustering for Nonstationary Time Series and
Wind Speed Behavior (2018) Tupper et al
}
