% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary_graph}
\alias{summary_graph}
\title{Summary graph}
\usage{
summary_graph(lin.anc, alpha = 0.05, corr = TRUE)
}
\arguments{
\item{lin.anc}{output from AncReg()}

\item{alpha}{significance level}

\item{corr}{should multiplicity correction be applied?}
}
\value{
A boolean matrix indicating whether one variable affects another
}
\description{
Construct summary graph from p-values and significance level.
Recursively constructs all ancestral connections by adding ancestors of ancestors.
}
\examples{
# random DAGS for simulation
set.seed(1234)

p <- 5 #number of nodes
DAG <- pcalg::randomDAG(p, prob = 0.5)

B <- matrix(0, p, p) # represent DAG as matrix
for (i in 2:p){
  for(j in 1:(i-1)){
    # store edge weights
    B[i,j] <- max(0, DAG@edgeData@data[[paste(j,"|",i, sep="")]]$weight)
  }
}
colnames(B) <- rownames(B) <- LETTERS[1:p]

# solution in terms of noise
Bprime <- MASS::ginv(diag(p) - B)

n <- 500
N <- matrix(rexp(n * p), ncol = p)
X <- t(Bprime \%*\% t(N))
colnames(X) <- LETTERS[1:p]

# fit ancestor regression
fit <- AncReg(X)

# generate summary graph
summary_graph(fit, alpha = 0.1)
}
\seealso{
\code{\link{AncReg}}, \code{\link{summary_p.val}}
}
