% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMrule.R
\name{SMrule}
\alias{SMrule}
\title{Slack maximizer rule}
\usage{
SMrule(c)
}
\arguments{
\item{c}{A numeric cost vector.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{SMrule} calculates the contribution vector selected by the SM rule.
}
\details{
For each \eqn{c\in C^N} and each \eqn{i\in N\backslash\{n\}}, the slack maximizer rule is defined by
\deqn{
\text{SM}_i(c) = \text{min} \Bigg\{ \dfrac{1}{r-i+2} \Big( c_r - \displaystyle\sum\limits_{j \in N^i_{-}} \text{SM}_j(c) \Big):r=i,\dots,n-1 \Bigg\},\
\text{SM}_n(c)=c_n-\displaystyle\sum\limits^{n-1}_{i=1}SM_i(c)
}
This rule aims to maximize the 'slacks',
that is, the available margin for each agent within the imposed constraints.

The contribution selected by the SM rule for a problem \eqn{c \in C^N} coincides with the payoff vector assigned
by the nucleolus to the associated cost game \eqn{v\in G^N}, that is, \eqn{\text{SM}(c)=\text{Nu}(v)}.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
SMrule(c)

}
\references{
Littlechild, S. C. (1974). A simple expression for the nucleolus in a special case. \emph{International Journal of Game Theory}, 3(1), 21-29.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{SIGMArule}}, \code{\link{basicrule}}, \code{\link{hierarchicalrule}}
}
