% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-QC.R
\name{QC_invalidateConsecutiveSuspectValues}
\alias{QC_invalidateConsecutiveSuspectValues}
\title{Invalidate consecutive suspect values.}
\usage{
QC_invalidateConsecutiveSuspectValues(
  x = NULL,
  suspectValues = c(0:10 * 1000, NA),
  consecutiveCount = 2
)
}
\arguments{
\item{x}{Timeseries data.}

\item{suspectValues}{Vector of numeric values considered suspect.}

\item{consecutiveCount}{How many \code{suspectValues} must appear in a row
before they are invalidated.}
}
\value{
Returns \code{x} with some values potentially replaced with \code{NA}.
}
\description{
Invalidates values within a timeseries that appear "sticky".
Some temporary monitoring data has stretches of consecutive values, sometimes
well outside the range of reasonable. This QC function identifies these
"sticky" stretches and returns the original timeseries data with "sticky"
stretches replaced with \code{NA}.
}
