% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{log_lik}
\alias{log_lik}
\title{Log-Likelihood Function for Spatial Model}
\usage{
log_lik(
  par,
  p1,
  p2,
  d1,
  d2,
  y,
  u_dist,
  n_x,
  tau2_1 = 1,
  tau2_2 = 1,
  age_param_data
)
}
\arguments{
\item{par}{A numeric vector of parameters to estimate. The vector contains:
\itemize{
  \item \code{par[1:p1]}: Coefficients for fixed effects in dataset 1
  (\eqn{\beta_1}).
  \item \code{par[(p1 + 1):(p1 + p2)]}: Coefficients for fixed effects in
  dataset 2 (\eqn{\beta_2}).
  \item \code{par[p1 + p2 + 1]}: Spatial decay parameter (\eqn{\gamma}).
  \item \code{par[p1 + p2 + 2]}: Log of the variance parameter
  (\eqn{\sigma^2}).
  \item \code{par[p1 + p2 + 3]}: Log of the range parameter (\eqn{\phi}).
}}

\item{p1}{An integer. The number of fixed-effect parameters in dataset 1.}

\item{p2}{An integer. The number of fixed-effect parameters in dataset 2.}

\item{d1}{A numeric matrix. Design matrix for dataset 1 used to model the
mean structure.}

\item{d2}{A numeric matrix. Design matrix for dataset 2 used to model the
mean structure.}

\item{y}{A numeric vector. Observed response variable, including both
datasets.}

\item{u_dist}{A numeric matrix. Distance matrix for spatial locations.}

\item{n_x}{An integer. The number of unique spatial locations.}

\item{tau2_1}{Variance parameter for first process (default = 1)}

\item{tau2_2}{Variance parameter for second process (default = 1)}

\item{age_param_data}{A numeric matrix or vector. Additional parameters
specific to age-based modeling.}
}
\value{
A numeric scalar. The computed log-likelihood value.
}
\description{
Computes the log-likelihood for a spatial statistical model with a covariance
structure determined by parameters including spatial decay and variance.
}
\details{
The log-likelihood is computed as:
\deqn{
-0.5 \left[ \log(\det(M)) + (y - \mu)^T M^{-1} (y - \mu) \right]
}
where:
\itemize{
  \item \eqn{M} is the covariance matrix, computed using \code{compute_cov}.
  \item \eqn{\mu} is the mean structure, determined by the design matrices
   \code{d1}, \code{d2} and coefficients \eqn{\beta_1, \beta_2}.
}

The covariance matrix \eqn{M} is computed using spatial parameters
 (\eqn{\gamma, \sigma^2, \phi}) and the distance matrix \code{u_dist}.
}
\note{
This function requires a helper function, \code{compute_cov}, to compute
 the covariance matrix based on spatial parameters.
}
