% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{temkin_model}
\alias{temkin_model}
\title{Temkin Isotherm Model}
\usage{
temkin_model(Ce, Qe, R = 8.314, T = 298)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}

  \item{R}{Universal gas constant (default is 8.314 J/mol·K).}

  \item{T}{Temperature in Kelvin (default is 298 K).}
}
\value{
A named list of Temkin parameters and model details.
}
\description{
The Temkin isotherm considers the effects of indirect adsorbate–adsorbate interactions. It assumes that
the heat of adsorption of all molecules in the layer decreases linearly with coverage (Temkin and Pyzhev, 1940).
The model is expressed as:

\deqn{Q = \frac{RT}{b_T} \cdot \ln(A_T \cdot C_e)}

where \eqn{Q} is the amount adsorbed, \eqn{C_e} is the equilibrium concentration,
\eqn{R} is the universal gas constant, \eqn{T} is the absolute temperature,
\eqn{b_T} is the Temkin constant related to adsorption heat, and \eqn{A_T} is the Temkin isotherm constant.

For more information, see Temkin and Pyzhev (1940).
}
\examples{
Ce <- c(1, 2, 3, 4, 5)
Qe <- c(0.8, 1.5, 2.1, 2.6, 2.9)
result <- temkin_model(Ce, Qe)
print(result[1:2])
print(result$`Model Summary`)
print(result$Plot)
}
\seealso{
Other linear models: \code{\link{bet_model}()}, \code{\link{freundlich_model}()}, \code{\link{langmuir_model}()}
}
