% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cond_forc.r
\name{plot_cond_forc}
\alias{plot_cond_forc}
\title{plot_cond_forc function; Data should conatain the variable "variable", the "hor" horizon and a "history"}
\usage{
plot_cond_forc(
  varbl2plot = NULL,
  y_h_cond = NULL,
  center = 0.5,
  lower = 0.16,
  upper = 0.84,
  T.start = NULL,
  T.end = NULL,
  before = 8,
  freq = "quarter",
  y_data = NULL
)
}
\arguments{
\item{varbl2plot}{name of variable to be plotted (string)}

\item{y_h_cond}{conditional forecast data frame (eg from SimScen) with names c("hor","variable","lower","center","upper"): hor is a Date object}

\item{center}{(optional, default 0.5) quantile of the mid value}

\item{lower}{(optional, default 0.16) quantile of lower range}

\item{upper}{(optional, default 0.84) quantile of upper range}

\item{T.start}{start date of the forecast}

\item{T.end}{end of the forecast}

\item{before}{(integer: optional) periods of data in the plot: default 8 periods}

\item{freq}{(optional, default 'quarter') frequency of the data (eg 'quarter' or 'month')}

\item{y_data}{Data used in the estimation eg t(specification$get_data_matrices()$Y) \%>\% as.data.frame(); true_data$hor=dates}
}
\value{
list of plot and data used
}
\description{
plot_cond_forc function; Data should conatain the variable "variable", the "hor" horizon and a "history"
}
\examples{
\dontrun{
# Example usage with conditional forecast data
plot_result <- plot_cond_forc(varbl2plot = "GDP", 
                              y_h_cond = forecast_data,
                              T.start = as.Date("2023-01-01"),
                              T.end = as.Date("2024-01-01"),
                              y_data = historical_data)
}

}
