% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMIS_outputs.R
\name{calculate_summaries}
\alias{calculate_summaries}
\title{Calculate summaries of weighted statistics}
\usage{
calculate_summaries(
  x,
  what = "prev",
  time = 1,
  locations = NULL,
  alpha = 0.05,
  exceedance_prob_threshold = 0.35
)
}
\arguments{
\item{x}{The output from the function \code{\link{amis}()}.}

\item{what}{What statistic should be calculated the summaries from.
It must be either \code{"prev"} or the name of one of the model parameters. Default to \code{"prev"}.}

\item{time}{Time point. Only used if \code{"what"} is set to \code{"prev"}.}

\item{locations}{Integer vector or location names identifying locations where
summaries should be calculated for. If not specified, summary statistics of
all locations will be provided.}

\item{alpha}{Numeric value between 0 and 1. Calculations are for the \code{(alpha/2, 1-alpha/2)}\% quantiles.}

\item{exceedance_prob_threshold}{Numeric value. Default to \code{0.35}, i.e. the
probability that the statistic of interest (e.g. prevalence) is higher than \code{0.35}.}
}
\value{
A list with mean, median, and quantiles of the weighted distribution.
}
\description{
Calculate summaries of weighted statistics
}
\details{
For illustrative examples, see \code{\link{amis}()}.
}
