/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropNotEqualXC
extends Propagator<IntVar> {
    private final int constant;

    public PropNotEqualXC(IntVar var, int cste) {
        super((Variable[])new IntVar[]{var}, (Priority)PropagatorPriority.UNARY, false, true);
        this.constant = cste;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((IntVar[])this.vars)[0].removeValue(this.constant, (ICause)this) || !((IntVar[])this.vars)[0].contains(this.constant)) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].isInstantiatedTo(this.constant)) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[0].contains(this.constant)) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntIterableRangeSet set = explanation.universe();
        set.remove(this.constant);
        ((IntVar[])this.vars)[0].intersectLit(set, explanation);
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " =/= " + this.constant;
    }
}

