/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.multiexprtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.IPrimitive;
import net.sourceforge.jclec.multiexprtree.MultiExprTreeIndividual;
import net.sourceforge.jclec.multiexprtree.MultiExprTreeSpecies;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class MultiExprTreeIndividualSpecies
extends MultiExprTreeSpecies
implements IConfigure {
    private static final long serialVersionUID = -5304951511814536309L;

    public void setNumberOfExprTrees(int numberOfExpressionTrees) {
        this.genotypeSchema = new ExprTreeSchema[numberOfExpressionTrees];
        int i = 0;
        while (i < numberOfExpressionTrees) {
            this.genotypeSchema[i] = new ExprTreeSchema();
            ++i;
        }
    }

    public void setMinTreeSize(int exprTreeIndex, int minimumTreeSize) {
        this.genotypeSchema[exprTreeIndex].setMinTreeSize(minimumTreeSize);
    }

    public void setMaxTreeSize(int exprTreeIndex, int maximumTreeSize) {
        this.genotypeSchema[exprTreeIndex].setMaxTreeSize(maximumTreeSize);
    }

    public void setRootType(int exprTreeIndex, Class<?> rootType) {
        this.genotypeSchema[exprTreeIndex].setRootType(rootType);
    }

    public void setTerminals(int exprTreeIndex, IPrimitive[] terminals) {
        this.genotypeSchema[exprTreeIndex].setTerminals(terminals);
    }

    public void setFunctions(int exprTreeIndex, IPrimitive[] functions) {
        this.genotypeSchema[exprTreeIndex].setFunctions(functions);
    }

    public MultiExprTreeIndividual createIndividual() {
        return new MultiExprTreeIndividual();
    }

    @Override
    public MultiExprTreeIndividual createIndividual(ExprTree[] genotype) {
        return new MultiExprTreeIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfPrefixExpressions = settings.getInt("[@number-of-trees]", 1);
        this.setNumberOfExprTrees(numberOfPrefixExpressions);
        int i = 0;
        while (i < numberOfPrefixExpressions) {
            String header = "expression-tree(" + i + ")";
            int minTreeSize = settings.getInt(String.valueOf(header) + ".min-tree-size");
            this.setMinTreeSize(i, minTreeSize);
            int maxTreeSize = settings.getInt(String.valueOf(header) + ".max-tree-size");
            this.setMaxTreeSize(i, maxTreeSize);
            String rootTypeName = settings.getString(String.valueOf(header) + ".root-type");
            try {
                Class<?> rootType = Class.forName(rootTypeName);
                this.setRootType(i, rootType);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("");
            }
            int numberOfTerminals = settings.getList(String.valueOf(header) + ".terminals.terminal[@class]").size();
            IPrimitive[] terminals = new IPrimitive[numberOfTerminals];
            int j = 0;
            while (j < numberOfTerminals) {
                try {
                    String terminalClassname = settings.getString(String.valueOf(header) + ".terminals.terminal(" + j + ")[@class]");
                    Class<?> terminalClass = Class.forName(terminalClassname);
                    terminals[j] = (IPrimitive)terminalClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (InstantiationException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationRuntimeException();
                }
                ++j;
            }
            this.setTerminals(i, terminals);
            int numberOfFunctions = settings.getList(String.valueOf(header) + ".functions.function[@class]").size();
            IPrimitive[] functions = new IPrimitive[numberOfFunctions];
            int j2 = 0;
            while (j2 < numberOfFunctions) {
                try {
                    String functionClassname = settings.getString(String.valueOf(header) + ".functions.function(" + j2 + ")[@class]");
                    Class<?> functionClass = Class.forName(functionClassname);
                    functions[j2] = (IPrimitive)functionClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (InstantiationException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationRuntimeException();
                }
                ++j2;
            }
            this.setFunctions(i, functions);
            ++i;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof MultiExprTreeIndividualSpecies) {
            MultiExprTreeIndividualSpecies cother = (MultiExprTreeIndividualSpecies)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.genotypeSchema, cother.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

