/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.intarray;

import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractMutator;
import net.sf.jclec.intarray.IIntArraySpecies;
import net.sf.jclec.intarray.IntArrayIndividual;
import net.sf.jclec.util.intset.IIntegerSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntArrayMutator<I extends IntArrayIndividual>
extends AbstractMutator<I> {
    protected transient IIntArraySpecies<I> species;
    protected transient IIntegerSet[] schema;

    @Override
    protected void prepareMutation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof IIntArraySpecies)) {
            throw new IllegalStateException("Invalid species in context");
        }
        this.species = (IIntArraySpecies)spc;
        this.schema = this.species.getGenotypeSchema();
    }

    protected final int getMutableLocus() {
        int ml;
        int genotypeLength = this.schema.length;
        while (this.schema[ml = this.randgen.choose(0, genotypeLength)].size() == 1) {
        }
        return ml;
    }

    protected final void flip(int[] chrom, int locus) {
        int newval;
        while (chrom[locus] == (newval = this.schema[locus].getRandom(this.randgen))) {
        }
        chrom[locus] = newval;
    }
}

