/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.MathUtils;

@Explained(partial=true, comment="not tested yet")
public class PropScale
extends Propagator<IntVar> {
    protected static final int MAX = 0x7FFFFFFE;
    protected static final int MIN = -2147483647;
    private final IntVar X;
    private final IntVar Z;
    private final int Y;
    private final boolean enumerated;

    public PropScale(IntVar x, int y, IntVar z) {
        super((Variable[])new IntVar[]{x, z}, (Priority)PropagatorPriority.BINARY, false);
        this.X = ((IntVar[])this.vars)[0];
        this.Z = ((IntVar[])this.vars)[1];
        this.Y = y;
        assert (y > 1);
        this.enumerated = this.X.hasEnumeratedDomain() && this.Z.hasEnumeratedDomain();
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        this.X.updateLowerBound(MathUtils.divCeil(this.Z.getLB(), this.Y), this, this.lcg() ? Reason.r(this.Z.getMinLit()) : Reason.undef());
        this.X.updateUpperBound(MathUtils.divFloor(this.Z.getUB(), this.Y), this, this.lcg() ? Reason.r(this.Z.getMaxLit()) : Reason.undef());
        boolean hasChanged = this.Z.updateLowerBound(this.X.getLB() * this.Y, this, this.lcg() ? Reason.r(this.X.getMinLit()) : Reason.undef());
        hasChanged |= this.Z.updateUpperBound(this.X.getUB() * this.Y, this, this.lcg() ? Reason.r(this.X.getMaxLit()) : Reason.undef());
        if (this.enumerated) {
            int zub = this.X.getUB();
            int v = this.X.getLB();
            while (v <= zub) {
                if (!this.Z.contains(v * this.Y)) {
                    this.X.removeValue(v, this, this.lcg() ? Reason.r(this.Z.getLit(v * this.Y, 0)) : Reason.undef());
                }
                v = this.X.nextValue(v);
            }
            v = this.Z.getLB();
            zub = this.Z.getUB();
            while (v <= zub) {
                if (v / this.Y * this.Y != v) {
                    this.Z.removeValue(v, this, Reason.undef());
                }
                if (!this.X.contains(v / this.Y)) {
                    this.Z.removeValue(v, this, this.lcg() ? Reason.r(this.X.getLit(v / this.Y, 0)) : Reason.undef());
                }
                v = this.Z.nextValue(v);
            }
        } else if (hasChanged && this.Z.hasEnumeratedDomain() && (this.Z.getLB() > this.X.getLB() * this.Y || this.Z.getUB() < this.X.getUB() * this.Y)) {
            this.propagate(evtmask);
        }
    }

    @Override
    public final ESat isEntailed() {
        if (this.X.getUB() * this.Y < this.Z.getLB() || this.X.getLB() * this.Y > this.Z.getUB()) {
            return ESat.FALSE;
        }
        if (this.X.isInstantiated() && this.Z.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

