/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.rosuda.deducer.plots.Coord;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.Facet;
import org.rosuda.deducer.plots.Layer;
import org.rosuda.deducer.plots.Scale;
import org.rosuda.deducer.plots.Theme;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlottingElement
implements Transferable {
    private ElementModel model;
    private ImageIcon icon;
    private String iconUrl;
    private String name;
    private String type;
    private String helpUrl = "";
    private boolean active = true;
    private boolean compound = false;
    public static DataFlavor DATAFLAVOR = new DataFlavor(PlottingElement.class, "Plotting element");

    public PlottingElement() {
    }

    public PlottingElement(String string, String string2, String string3) {
        URL uRL = this.getClass().getResource(string);
        this.iconUrl = string;
        this.name = string3;
        this.type = string2;
        if (this.type.equals("geom")) {
            Layer layer = Layer.makeGeomLayer(this.name);
            this.model = layer;
            this.helpUrl = "http://had.co.nz/ggplot2/" + this.type + "_" + this.name + ".html";
            if (uRL == null) {
                this.iconUrl = "/icons/ggplot_icons/layer_default.png";
                uRL = this.getClass().getResource(this.iconUrl);
            }
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        } else if (this.type.equals("stat")) {
            Layer layer = Layer.makeStatLayer(this.name);
            this.model = layer;
            this.helpUrl = "http://had.co.nz/ggplot2/" + this.type + "_" + this.name + ".html";
            if (uRL == null) {
                this.iconUrl = "/icons/ggplot_icons/layer_default.png";
                uRL = this.getClass().getResource(this.iconUrl);
            }
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        } else if (this.type.equals("scale")) {
            String[] stringArray = this.name.split("_");
            if (stringArray.length > 1) {
                this.model = Scale.makeScale(stringArray[0], stringArray[1]);
                this.helpUrl = "http://had.co.nz/ggplot2/" + this.type + "_" + stringArray[1] + ".html";
            } else {
                this.model = Scale.makeScale(null, stringArray[0]);
                this.helpUrl = "http://had.co.nz/ggplot2/" + this.type + "_" + stringArray[0] + ".html";
            }
            if (uRL == null) {
                this.iconUrl = "/icons/ggplot_icons/scale_default.png";
                uRL = this.getClass().getResource(this.iconUrl);
            }
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        } else if (this.type.equals("coord")) {
            Coord coord = Coord.makeCoord(this.name);
            this.model = coord;
            this.helpUrl = "http://had.co.nz/ggplot2/" + this.type + "_" + this.name + ".html";
            if (uRL == null) {
                this.iconUrl = "/icons/ggplot_icons/default.png";
                uRL = this.getClass().getResource(this.iconUrl);
            }
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        } else if (this.type.equals("facet")) {
            Facet facet = Facet.makeFacet(this.name);
            this.model = facet;
            this.helpUrl = "http://had.co.nz/ggplot2/" + this.type + "_" + this.name + ".html";
            if (uRL == null) {
                this.iconUrl = "/icons/ggplot_icons/default.png";
                uRL = this.getClass().getResource(this.iconUrl);
            }
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        } else if (this.type.equals("theme")) {
            Theme theme = Theme.makeTheme(this.name);
            this.model = theme;
            if (uRL == null) {
                this.iconUrl = "/icons/ggplot_icons/default.png";
                uRL = this.getClass().getResource(this.iconUrl);
            }
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        } else if (this.type.equals("template")) {
            URL uRL2 = this.getClass().getResource("/templates/" + this.name + ".ggtmpl");
            this.helpUrl = "http://www.deducer.org/pmwiki/pmwiki.php?n=Main.Templates";
            if (uRL2 != null) {
                this.setFromURL(uRL2);
            }
            if (uRL == null) {
                this.iconUrl = "/icons/ggplot_icons/template_default.png";
                uRL = this.getClass().getResource(this.iconUrl);
            }
            if (uRL != null) {
                this.icon = new ImageIcon(uRL);
            }
        }
        if (this.model == null) {
            // empty if block
        }
    }

    public void setIconFromUrl(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            this.icon = new ImageIcon(uRL);
            this.iconUrl = string;
        }
    }

    public Object clone() {
        PlottingElement plottingElement = new PlottingElement();
        plottingElement.model = (ElementModel)this.model.clone();
        plottingElement.icon = this.icon;
        plottingElement.name = this.name;
        plottingElement.type = this.type;
        plottingElement.helpUrl = this.helpUrl;
        plottingElement.iconUrl = this.iconUrl;
        return plottingElement;
    }

    public static PlottingElement createElement(String string, String string2) {
        String string3 = string2;
        String[] stringArray = string3.split("_");
        if (stringArray.length > 1) {
            string3 = stringArray[stringArray.length - 1];
        }
        PlottingElement plottingElement = !string.equals("template") ? new PlottingElement("/icons/ggplot_icons/" + string + "_" + string3 + ".png", string, string2) : new PlottingElement("/icons/ggplot_icons/" + string + "_" + string2 + ".png", string, string2);
        return plottingElement;
    }

    public JPanel makeComponent() {
        Serializable serializable;
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (this.active) {
            jLabel = new JLabel(this.icon);
        } else {
            serializable = this.getClass().getResource("/icons/edit_remove_32.png");
            jLabel = new JLabel(new ImageIcon((URL)serializable));
        }
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        serializable = new JLabel(this.type);
        ((JComponent)serializable).setAlignmentX(0.5f);
        ((JComponent)serializable).setFont(new Font("Dialog", 0, 8));
        jPanel.add((Component)serializable);
        String[] stringArray = this.name.split("_");
        for (int i = 0; i < stringArray.length; ++i) {
            serializable = new JLabel(stringArray[i]);
            ((JComponent)serializable).setAlignmentX(0.5f);
            ((JComponent)serializable).setFont(new Font("Dialog", 0, 12));
            jPanel.add((Component)serializable);
        }
        if (!this.active) {
            jPanel.setPreferredSize(new Dimension(80, 70));
        }
        jPanel.setBorder(new EtchedBorder());
        return jPanel;
    }

    public Image getImage() {
        return this.icon.getImage();
    }

    public void setImage(Image image) {
        this.icon = new ImageIcon(image);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public JPanel getPanel() {
        return this.model.getView();
    }

    public ElementModel getModel() {
        return this.model;
    }

    public void setModel(ElementModel elementModel) {
        this.model = elementModel;
    }

    public String getUrl() {
        return this.helpUrl;
    }

    public void setUrl(String string) {
        this.helpUrl = string;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isCompound() {
        return this.compound;
    }

    public void setCompound(boolean bl) {
        this.compound = bl;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(PlottingElement.class, "Plot element")};
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return true;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("PlottingElement");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.type != null) {
                element.setAttribute("type", this.type);
            }
            if (this.helpUrl != null) {
                element.setAttribute("helpUrl", this.helpUrl);
            }
            if (this.iconUrl != null) {
                element.setAttribute("iconUrl", this.iconUrl);
            }
            element.setAttribute("active", this.active ? "true" : "false");
            element.setAttribute("compound", this.compound ? "true" : "false");
            Element element2 = this.model.toXML();
            element2 = (Element)document.importNode(element2, true);
            element.appendChild(element2);
            element.setAttribute("className", "org.rosuda.deducer.plots.PlottingElement");
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.PlottingElement")) {
            System.out.println("Error Position: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.type = element.hasAttribute("type") ? element.getAttribute("type") : null;
        this.helpUrl = element.hasAttribute("helpUrl") ? element.getAttribute("helpUrl") : null;
        this.iconUrl = element.hasAttribute("iconUrl") ? element.getAttribute("iconUrl") : null;
        URL uRL = this.iconUrl == null ? this.getClass().getResource("/icons/ggplot_icons/default.png") : this.getClass().getResource(this.iconUrl);
        if (uRL != null) {
            this.icon = new ImageIcon(uRL);
        }
        Element element2 = (Element)element.getElementsByTagName("ElementModel").item(0);
        String string2 = element2.getAttribute("className");
        try {
            ElementModel elementModel = (ElementModel)Class.forName(string2).newInstance();
            elementModel.setFromXML(element2);
            this.model = elementModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveToFile(File file) {
        Element element = this.toXML();
        Document document = element.getOwnerDocument();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(string);
            outputStreamWriter.close();
            fileOutputStream.close();
            stringWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFromFile(File file) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = (Element)document.getChildNodes().item(0);
            this.setFromXML(element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFromURL(URL uRL) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(uRL.openStream());
            Element element = (Element)document.getChildNodes().item(0);
            this.setFromXML(element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

