/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.KeyboardInput;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class UserInput {
    public static AbstractXMLObjectParser STRING_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new StringAttributeRule("prompt", "A message displayed to the user when entering a value for this string", "Enter the name of a dinosaur:"), new ElementRule(String.class))};

        @Override
        public String getParserName() {
            return "string";
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            if (xMLObject.hasAttribute("prompt")) {
                String string = xMLObject.getStringAttribute("prompt");
                System.out.print(string + ": ");
                System.out.flush();
                return input.readString();
            }
            return xMLObject.getChild(String.class);
        }

        @Override
        public String getParserDescription() {
            return "returns a String. If a prompt attribute exists then the user is prompted for input, otherwise the character contents of the element are returned.";
        }

        @Override
        public Class getReturnType() {
            return String.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    public static AbstractXMLObjectParser DOUBLE_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new StringAttributeRule("prompt", "A message displayed to the user when entering a value for this double", "Enter the length of a piece of string (in metres):"), new ElementRule(Double.class))};

        @Override
        public String getParserName() {
            return "double";
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            if (xMLObject.hasAttribute("prompt")) {
                String string = xMLObject.getStringAttribute("prompt");
                System.out.print(string + ": ");
                System.out.flush();
                return new Double(input.readDouble());
            }
            return xMLObject.getChild(Double.class);
        }

        @Override
        public String getParserDescription() {
            return "returns a Double. If a prompt attribute exists then the user is prompted for input, otherwise the character contents of the element are returned as a Double.";
        }

        @Override
        public Class getReturnType() {
            return Double.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    public static AbstractXMLObjectParser INTEGER_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new StringAttributeRule("prompt", "A message displayed to the user when entering a value for this integer", "Enter the number of categories:"), new ElementRule(Integer.class))};

        @Override
        public String getParserName() {
            return "integer";
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            if (xMLObject.hasAttribute("prompt")) {
                String string = xMLObject.getStringAttribute("prompt");
                System.out.print(string + ": ");
                System.out.flush();
                return new Integer(input.readInteger());
            }
            return xMLObject.getChild(Integer.class);
        }

        @Override
        public String getParserDescription() {
            return "returns an Integer. If a prompt attribute exists then the user is prompted for input, otherwise the character contents of the element are returned as an Integer.";
        }

        @Override
        public Class getReturnType() {
            return Integer.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    static KeyboardInput input = new KeyboardInput();
}

