/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evomodel.continuous.SoftThresholdLikelihood;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Profileable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PathLikelihood
implements Likelihood,
Profileable {
    public static final String PATH_LIKELIHOOD = "pathLikelihood";
    public static final String PATH_PARAMETER = "theta";
    public static final String DIFFERENCE = "delta";
    public static final String SOURCE = "source";
    public static final String DESTINATION = "destination";
    public static final String PSUEDO_SOURCE = "sourcePseudoPrior";
    public static final String PSUEDO_DESTINATION = "destinationPseudoPrior";
    private boolean isUsed = false;
    private String id = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("source", new XMLSyntaxRule[]{new ElementRule(Likelihood.class)}), new ElementRule("destination", new XMLSyntaxRule[]{new ElementRule(Likelihood.class)}), new ElementRule("sourcePseudoPrior", new XMLSyntaxRule[]{new ElementRule(Likelihood.class)}, true), new ElementRule("destinationPseudoPrior", new XMLSyntaxRule[]{new ElementRule(Likelihood.class)}, true)};

        @Override
        public String getParserName() {
            return PathLikelihood.PATH_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Likelihood likelihood = (Likelihood)xMLObject.getElementFirstChild(PathLikelihood.SOURCE);
            Likelihood likelihood2 = (Likelihood)xMLObject.getElementFirstChild(PathLikelihood.DESTINATION);
            Likelihood likelihood3 = null;
            if (xMLObject.hasChildNamed(PathLikelihood.PSUEDO_SOURCE)) {
                likelihood3 = (Likelihood)xMLObject.getElementFirstChild(PathLikelihood.PSUEDO_SOURCE);
            }
            Likelihood likelihood4 = null;
            if (xMLObject.hasChildNamed(PathLikelihood.PSUEDO_DESTINATION)) {
                likelihood4 = (Likelihood)xMLObject.getElementFirstChild(PathLikelihood.PSUEDO_DESTINATION);
            }
            return new PathLikelihood(likelihood, likelihood2, likelihood3, likelihood4);
        }

        @Override
        public String getParserDescription() {
            return "A likelihood function used for estimating marginal likelihoods and Bayes factors using path sampling.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return CompoundLikelihood.class;
        }
    };
    private final Likelihood source;
    private final Likelihood destination;
    private final Likelihood pseudoSource;
    private final Likelihood pseudoDestination;
    private double pathParameter;
    private final CompoundModel compoundModel = new CompoundModel("compoundModel");
    private ArrayList<SoftThresholdLikelihood> thresholdSofteners = new ArrayList();

    public PathLikelihood(Likelihood likelihood, Likelihood likelihood2) {
        this(likelihood, likelihood2, null, null);
    }

    public PathLikelihood(Likelihood likelihood, Likelihood likelihood2, Likelihood likelihood3, Likelihood likelihood4) {
        int n;
        this.source = likelihood;
        this.destination = likelihood2;
        this.pseudoSource = likelihood3;
        this.pseudoDestination = likelihood4;
        if (likelihood != null) {
            for (n = 0; n < likelihood.getModel().getModelCount(); ++n) {
                for (int i = 0; i < likelihood.getModel().getModel(n).getModelCount(); ++i) {
                    if (!(likelihood.getModel().getModel(n).getModel(i) instanceof SoftThresholdLikelihood)) continue;
                    this.thresholdSofteners.add((SoftThresholdLikelihood)((Object)likelihood.getModel().getModel(n).getModel(i)));
                }
            }
        }
        if (likelihood3 != null) {
            for (n = 0; n < likelihood3.getModel().getModelCount(); ++n) {
                if (!(likelihood3.getModel().getModel(n) instanceof SoftThresholdLikelihood)) continue;
                this.thresholdSofteners.add((SoftThresholdLikelihood)((Object)likelihood3.getModel().getModel(n)));
            }
        }
        this.compoundModel.addModel(likelihood.getModel());
        this.compoundModel.addModel(likelihood2.getModel());
    }

    public double getPathParameter() {
        return this.pathParameter;
    }

    public void setPathParameter(double d) {
        this.pathParameter = d;
        if (this.thresholdSofteners != null) {
            for (SoftThresholdLikelihood softThresholdLikelihood : this.thresholdSofteners) {
                softThresholdLikelihood.setPathParameter(d);
            }
        }
    }

    @Override
    public Model getModel() {
        return this.compoundModel;
    }

    @Override
    public double getLogLikelihood() {
        return this.source.getLogLikelihood() * this.pathParameter + this.destination.getLogLikelihood() * (1.0 - this.pathParameter);
    }

    public Likelihood getSourceLikelihood() {
        return this.source;
    }

    public Likelihood getDestinationLikelihood() {
        return this.destination;
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        HashSet<Likelihood> hashSet = new HashSet<Likelihood>();
        hashSet.add(this.source);
        hashSet.add(this.destination);
        return hashSet;
    }

    @Override
    public void makeDirty() {
        this.source.makeDirty();
        this.destination.makeDirty();
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    public String toString() {
        return Double.toString(this.getLogLikelihood());
    }

    @Override
    public long getTotalCalculationCount() {
        long l = 0L;
        if (this.source instanceof Profileable) {
            l += ((Profileable)((Object)this.source)).getTotalCalculationCount();
        }
        if (this.destination instanceof Profileable) {
            l += ((Profileable)((Object)this.destination)).getTotalCalculationCount();
        }
        return l;
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new DeltaLogLikelihoodColumn(this.getId() + "." + DIFFERENCE), new PosteriorColumn(this.getId() + "." + SOURCE), new PriorColumn(this.getId() + "." + DESTINATION), new ThetaColumn(this.getId() + "." + PATH_PARAMETER), new PathLikelihoodColumn(this.getId() + "." + PATH_LIKELIHOOD)};
    }

    @Override
    public boolean isUsed() {
        return this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    private class DeltaLogLikelihoodColumn
    extends NumberColumn {
        public DeltaLogLikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            double d = 0.0;
            if (PathLikelihood.this.thresholdSofteners != null) {
                for (SoftThresholdLikelihood softThresholdLikelihood : PathLikelihood.this.thresholdSofteners) {
                    d += softThresholdLikelihood.getLikelihoodCorrection();
                }
            }
            double d2 = PathLikelihood.this.source.getLogLikelihood() - PathLikelihood.this.destination.getLogLikelihood() + d;
            if (PathLikelihood.this.pseudoSource != null) {
                d2 -= PathLikelihood.this.pseudoSource.getLogLikelihood();
            }
            if (PathLikelihood.this.pseudoDestination != null) {
                // empty if block
            }
            return d2;
        }
    }

    private class PosteriorColumn
    extends NumberColumn {
        public PosteriorColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return PathLikelihood.this.source.getLogLikelihood();
        }
    }

    private class PriorColumn
    extends NumberColumn {
        public PriorColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return PathLikelihood.this.destination.getLogLikelihood();
        }
    }

    private class ThetaColumn
    extends NumberColumn {
        public ThetaColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return PathLikelihood.this.pathParameter;
        }
    }

    private class PathLikelihoodColumn
    extends NumberColumn {
        public PathLikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return PathLikelihood.this.getLogLikelihood();
        }
    }
}

