/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.distance;

import dr.evolution.distance.DistanceMatrix;
import dr.evolution.io.Importer;
import dr.evolution.io.NexusImporter;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.matrix.Matrix;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;

public class PatristicDistanceMatrix
extends DistanceMatrix {
    Tree tree;

    public PatristicDistanceMatrix(Tree tree) {
        this.tree = tree;
        this.dimension = tree.getExternalNodeCount();
        this.distancesKnown = false;
        this.calculateDistances();
    }

    @Override
    protected double calculatePairwiseDistance(int n, int n2) {
        NodeRef nodeRef = this.tree.getExternalNode(n);
        NodeRef nodeRef2 = this.tree.getExternalNode(n2);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.tree.getNodeTaxon(nodeRef).getId());
        hashSet.add(this.tree.getNodeTaxon(nodeRef2).getId());
        NodeRef nodeRef3 = TreeUtils.getCommonAncestorNode(this.tree, hashSet);
        if (nodeRef3 == null) {
            System.out.println("common ancestor is null!");
        }
        double d = this.height(this.tree, nodeRef, nodeRef3);
        double d2 = this.height(this.tree, nodeRef2, nodeRef3);
        return d + d2;
    }

    public double height(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        if (nodeRef == nodeRef2) {
            return 0.0;
        }
        return tree.getBranchLength(nodeRef) + this.height(tree, tree.getParent(nodeRef), nodeRef2);
    }

    @Override
    public String toString() {
        try {
            int n;
            double[] dArray = this.getUpperTriangle();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" \t");
            for (n = 0; n < this.dimension; ++n) {
                stringBuffer.append(this.tree.getNodeTaxon(this.tree.getExternalNode(n))).append("\t");
            }
            stringBuffer.append("\n");
            n = 0;
            for (int i = 0; i < this.dimension; ++i) {
                int n2;
                stringBuffer.append(this.tree.getNodeTaxon(this.tree.getExternalNode(i)));
                for (n2 = 0; n2 <= i; ++n2) {
                    stringBuffer.append("\t");
                }
                for (n2 = 0; n2 < this.dimension - i - 1; ++n2) {
                    stringBuffer.append(String.valueOf(dArray[n])).append("\t");
                    ++n;
                }
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        catch (Matrix.NotSquareException notSquareException) {
            return notSquareException.toString();
        }
    }

    public static void main(String[] stringArray) throws IOException, Importer.ImportException {
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        NexusImporter nexusImporter = new NexusImporter(new FileReader(file));
        List<Tree> list = nexusImporter.importTrees(null);
        System.out.println("Found " + list.size() + " trees.");
        for (Tree tree : list) {
            PatristicDistanceMatrix patristicDistanceMatrix = new PatristicDistanceMatrix(tree);
            printWriter.println(patristicDistanceMatrix.toString());
        }
        printWriter.flush();
        printWriter.close();
    }
}

