/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RString;
import org.jpmml.rexp.RVector;

public class RFunctionCall
extends RPair {
    public RFunctionCall(RExp tag, RExp value, RPair arguments, RPair attributes) {
        super(tag, value, attributes);
        this.setNext(arguments);
    }

    public boolean hasValue(String string) {
        RString value = (RString)this.getValue();
        return Objects.equals(string, value.getValue());
    }

    public Iterator<RPair> arguments() {
        Iterator<RPair> result = new Iterator<RPair>(){
            private RPair next;
            {
                this.next = RFunctionCall.this.getNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public RPair next() {
                RPair result = this.next;
                if (result == null) {
                    throw new NoSuchElementException();
                }
                this.next = result.getNext();
                return result;
            }
        };
        return result;
    }

    public Iterator<RExp> argumentValues() {
        Iterator<RExp> result = new Iterator<RExp>(){
            private Iterator<RPair> argumentIt;
            {
                this.argumentIt = RFunctionCall.this.arguments();
            }

            @Override
            public boolean hasNext() {
                return this.argumentIt.hasNext();
            }

            @Override
            public RExp next() {
                RPair argument = this.argumentIt.next();
                return argument.getValue();
            }
        };
        return result;
    }

    public String toTreeString(String indent) {
        StringBuilder sb = new StringBuilder();
        RString value = (RString)this.getValue();
        sb.append(indent).append(value.getValue());
        indent = indent + "\t";
        Iterator<RExp> it = this.argumentValues();
        while (it.hasNext()) {
            RExp argValue = it.next();
            sb.append("\n");
            if (argValue instanceof RString) {
                RString string = (RString)argValue;
                sb.append(indent).append(string.getValue()).append(" // ").append(argValue.getClass().getSimpleName());
                continue;
            }
            if (argValue instanceof RVector) {
                RVector vector = (RVector)argValue;
                sb.append(indent).append(vector.asScalar()).append(" // ").append(argValue.getClass().getSimpleName());
                continue;
            }
            if (argValue instanceof RFunctionCall) {
                RFunctionCall functionCall = (RFunctionCall)argValue;
                sb.append(functionCall.toTreeString(indent));
                continue;
            }
            throw new IllegalArgumentException(argValue.getClass().getName());
        }
        return sb.toString();
    }
}

