/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import eu.kliegr.ac1.BaseConfig;
import eu.kliegr.ac1.Rinterface.discretization.DiscretizeType;
import eu.kliegr.ac1.Rinterface.discretization.MissingValueTreatmentEnum;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class DiscretizeConfig
extends BaseConfig {
    private static final Logger LOGGER = Logger.getLogger(BaseConfig.class.getName());
    private final String dataPath;
    private final String outputDataPath;
    private final String testDataPath;
    private final String testOutputDataPath;
    private final DiscretizeType discretizeType;
    private final MissingValueTreatmentEnum missingValueTreatment;

    public DiscretizeConfig(String path) throws FileNotFoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        Properties prop = new Properties();
        prop.loadFromXML(input);
        this.dataPath = prop.getProperty("DataPath");
        this.outputDataPath = prop.getProperty("OutputPath");
        if (prop.containsKey("TestDataPath")) {
            this.testDataPath = prop.getProperty("TestDataPath");
            this.testOutputDataPath = prop.getProperty("TestOutputPath");
        } else {
            this.testDataPath = null;
            this.testOutputDataPath = null;
        }
        this.discretizeType = DiscretizeType.valueOf(prop.getProperty("DiscretizeType"));
        this.missingValueTreatment = MissingValueTreatmentEnum.valueOf(prop.getProperty("MissingValueTreatment"));
        this.csvSeparator = prop.getProperty("DataTypes").contains(";") ? ";" : ",";
        this.attType = this.parseAttributeTypes(prop.getProperty("DataTypes").split(this.csvSeparator));
        this.IDcolumnName = prop.getProperty("IDcolumnName");
        this.targetAttribute = prop.getProperty("TargetAttribute");
    }

    public MissingValueTreatmentEnum getMissingValueTreatment() {
        return this.missingValueTreatment;
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    public String getOutputDataPath() {
        return this.outputDataPath;
    }

    public String getTestDataPath() {
        return this.testDataPath;
    }

    public String getTestOutputDataPath() {
        return this.testOutputDataPath;
    }

    public DiscretizeType getDiscretizeType() {
        return this.discretizeType;
    }
}

