## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ggplot2)
library(lofifonts)

## ----fontsheets, fig.height = 3, fig.width = 4--------------------------------
lo <- utf8ToInt('a')
hi <- utf8ToInt('z')
txt <- intToUtf8(seq(lo, hi))

for (font_name in get_lofi_names('bitmap')) {
  coords <- bitmap_text_coords(txt, font_name)
  
  p <- ggplot(coords) +
    geom_tile(aes(x0, y0), width=1, height = 1, na.rm = TRUE) +
    facet_wrap(~char_idx, ncol = 9)+
    theme_minimal(15) +
    coord_equal() + 
    labs(title = font_name) +
    theme(
      strip.text = element_blank(),
      axis.text  = element_blank(),
      axis.title = element_blank()
    )
  
  print(p)
}

