/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.IGeneralizedInverse;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;

public class MoorePenrose
implements IGeneralizedInverse {
    private double zero = 1.0E-12;
    private static final double ZERO = 1.0E-12;

    @Override
    public Matrix inverse(Matrix G) {
        int m = G.getRowsCount();
        int n = G.getColumnsCount();
        Matrix S = SymmetricMatrix.XtX(G);
        SymmetricMatrix.lcholesky(S, this.zero);
        DataBlock d = S.diagonal();
        int r = 0;
        for (int i = 0; i < n; ++i) {
            if (d.get(i) == 0.0) continue;
            ++r;
        }
        Matrix L = new Matrix(n, r);
        DataBlockIterator scols = S.columns();
        DataBlockIterator lcols = L.columns();
        DataBlock scol = scols.getData();
        DataBlock lcol = lcols.getData();
        do {
            if (d.get(scols.getPosition()) == 0.0) continue;
            lcol.copy(scol);
            lcols.next();
        } while (scols.next());
        Matrix K = SymmetricMatrix.XtX(L);
        SymmetricMatrix.lcholesky(K);
        LowerTriangularMatrix.rsolve(K, L.all().transpose());
        LowerTriangularMatrix.lsolve(K, L.all());
        Matrix I = new Matrix(n, m);
        I.all().product(SymmetricMatrix.XXt(L).all(), G.all().transpose());
        I.clean(this.zero);
        return I;
    }

    public void setZero(double val) {
        this.zero = val;
    }

    public double getZero() {
        return this.zero;
    }
}

