/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.FiniteFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.linearfilters.IRationalFilter;
import ec.tstoolkit.maths.linearfilters.LinearFilterException;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.linearfilters.RationalForeFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.utilities.Arrays2;

public class RationalFilter
implements IRationalFilter {
    private RationalBackFilter m_rb;
    private RationalForeFilter m_rf;
    private IFiniteFilter m_n;
    private IFiniteFilter m_d;

    private RationalFilter() {
    }

    public static RationalFilter RationalSymmetricFilter(BackFilter N, BackFilter D) {
        BackFilter.SimplifyingTool bsmp = new BackFilter.SimplifyingTool(true);
        if (bsmp.simplify(N, D)) {
            N = (BackFilter)bsmp.getLeft();
            D = (BackFilter)bsmp.getRight();
        }
        SymmetricFilter n = SymmetricFilter.createFromFilter(N);
        BackFilter g = n.decompose(D);
        RationalFilter rf = new RationalFilter();
        rf.m_rb = new RationalBackFilter(g, D);
        rf.m_rf = rf.m_rb.mirror();
        rf.m_n = SymmetricFilter.createFromFilter(N);
        rf.m_d = SymmetricFilter.createFromFilter(D);
        return rf;
    }

    @Deprecated
    public static RationalFilter RSFilter(BackFilter bnum, BackFilter bdenom) {
        return RationalFilter.RationalSymmetricFilter(bnum, bdenom);
    }

    public RationalFilter(BackFilter bnum, BackFilter bdenom, ForeFilter fnum, ForeFilter fdenom) {
        this.m_n = FiniteFilter.multiply((IFiniteFilter)bnum, fnum);
        this.m_d = FiniteFilter.multiply((IFiniteFilter)bdenom, fdenom);
        this.decompose(this.m_n, bdenom, fdenom);
    }

    public RationalFilter(IFiniteFilter N, BackFilter DB, ForeFilter DF) {
        this.m_n = new FiniteFilter(N);
        this.m_d = FiniteFilter.multiply((IFiniteFilter)new FiniteFilter(DB), DF);
        this.decompose(N, DB, DF);
    }

    public RationalFilter(RationalBackFilter rbf, RationalForeFilter rff) {
        this.m_rb = rbf;
        this.m_rf = rff;
    }

    public RationalFilter(RationalBackFilter rbf, RationalForeFilter rff, IFiniteFilter num, IFiniteFilter denom) {
        this.m_rb = rbf;
        this.m_rf = rff;
        this.m_n = num;
        this.m_d = denom;
    }

    private void decompose(IFiniteFilter num, BackFilter bd, ForeFilter fd) {
        int i;
        int i2;
        int k;
        int nnf;
        int nnb0 = -num.getLowerBound();
        int nnf0 = num.getUpperBound();
        double[] nc = num.getWeights();
        int nnb = nnb0;
        if (nnb < 0) {
            nnb = 0;
        }
        if ((nnf = nnf0) < 0) {
            nnf = 0;
        }
        int ndb = -bd.getLowerBound();
        int ndf = fd.getUpperBound();
        int h = Math.max(nnf, ndf);
        int ne = h + (k = Math.max(nnb, ndb)) + 1;
        if (nc.length != ne) {
            double[] ntmp = new double[ne];
            System.arraycopy(nc, 0, ntmp, k - nnb0, nc.length);
            nc = ntmp;
        }
        double[] cnb = new double[k + 1];
        double[] cnf = new double[h + 1];
        cnf[0] = 0.0;
        double[] db = bd.getWeights();
        double[] df = fd.getWeights();
        Matrix m = new Matrix(ne, ne);
        for (i2 = 0; i2 <= ndf; ++i2) {
            for (int j = 0; j <= k; ++j) {
                m.set(i2 + j, j, df[i2]);
            }
        }
        i2 = -ndb + 1 + k;
        for (int ii = 0; ii <= ndb; ++ii) {
            for (int j = 0; j < h; ++j) {
                m.set(i2 + j, j + k + 1, db[ii]);
            }
            ++i2;
        }
        Householder qr = new Householder(false);
        qr.decompose(m);
        try {
            nc = qr.solve(nc);
        }
        catch (MatrixException e) {
            throw new LinearFilterException("Invalid decomposition of rational filter", "RFilter.decompose");
        }
        for (i = 0; i <= k; ++i) {
            cnb[i] = nc[i];
        }
        for (i = 1; i <= h; ++i) {
            cnf[i] = nc[i + k];
        }
        Arrays2.reverse(cnb);
        this.m_rb = new RationalBackFilter(BackFilter.of(cnb), bd);
        this.m_rf = new RationalForeFilter(new ForeFilter(cnf), fd);
    }

    @Override
    public Complex frequencyResponse(double freq) {
        Complex nb = this.m_rb.frequencyResponse(freq);
        Complex nf = this.m_rf.frequencyResponse(freq);
        return nb.plus(nf);
    }

    @Override
    public IFiniteFilter getDenominator() {
        if (this.m_d == null) {
            FiniteFilter b = new FiniteFilter(this.m_rb.getDenominator());
            FiniteFilter f = new FiniteFilter(this.m_rf.getDenominator());
            FiniteFilter d = FiniteFilter.multiply((IFiniteFilter)b, f);
            d.smooth();
            this.m_d = d;
        }
        return this.m_d;
    }

    public int getLBound() {
        return this.m_rb.getUBound();
    }

    @Override
    public IFiniteFilter getNumerator() {
        if (this.m_n == null) {
            FiniteFilter nb = new FiniteFilter(this.m_rb.getNumerator());
            FiniteFilter nf = new FiniteFilter(this.m_rf.getNumerator());
            FiniteFilter db = new FiniteFilter(this.m_rb.getDenominator());
            FiniteFilter df = new FiniteFilter(this.m_rf.getDenominator());
            FiniteFilter n = FiniteFilter.add((IFiniteFilter)FiniteFilter.multiply((IFiniteFilter)nb, df), FiniteFilter.multiply((IFiniteFilter)nf, db));
            n.smooth();
            this.m_n = n;
        }
        return this.m_n;
    }

    public RationalBackFilter getRationalBackFilter() {
        return this.m_rb;
    }

    public RationalForeFilter getRationalForeFilter() {
        return this.m_rf;
    }

    public int getUBound() {
        return this.m_rf.getUBound();
    }

    @Override
    public double getWeight(int pos) {
        double d = 0.0;
        if (pos <= 0) {
            d = this.m_rb.getWeight(pos);
        }
        if (pos >= 0) {
            d += this.m_rf.getWeight(pos);
        }
        return d;
    }

    @Override
    public boolean hasLowerBound() {
        return this.m_rb.hasLowerBound();
    }

    @Override
    public boolean hasUpperBound() {
        return this.m_rf.hasUpperBound();
    }

    public void prepare(int n, int m) {
        this.m_rb.prepare(n);
        this.m_rf.prepare(m);
    }
}

