/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.denton;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.timeseries.TsAggregationType;

public class DentonMethod {
    public boolean mul_ = true;
    public boolean mod_ = true;
    public int diff_ = 1;
    public int conv_ = 12;
    public int offset_ = 0;
    public TsAggregationType type_ = TsAggregationType.Sum;

    private void J(SubMatrix M) {
        int j = this.offset_;
        DataBlockIterator rows = M.rows();
        DataBlock data = rows.getData();
        do {
            switch (this.type_) {
                case Sum: 
                case Average: {
                    data.range(j, j + this.conv_).set(1.0);
                    break;
                }
                case First: {
                    data.set(j, 1.0);
                    break;
                }
                case Last: {
                    data.set(j + this.conv_ - 1, 1.0);
                }
            }
            j += this.conv_;
        } while (rows.next());
    }

    private Matrix D(DataBlock x) {
        Polynomial pd = UnitRoots.D(1, this.diff_);
        int d = pd.getDegree();
        int n = x.getLength();
        if (this.mul_) {
            x = x.deepClone();
            x.inv();
        }
        if (this.mod_) {
            Matrix D = new Matrix(n - d, n);
            for (int i = 0; i <= d; ++i) {
                if (this.mul_) {
                    D.subDiagonal(i).setAY(pd.get(d - i), x.drop(i, d - i));
                    continue;
                }
                D.subDiagonal(i).set(pd.get(d - i));
            }
            return D;
        }
        Matrix D = new Matrix(n, n);
        for (int i = 0; i <= d; ++i) {
            if (this.mul_) {
                D.subDiagonal(-i).setAY(pd.get(i), x.drop(0, i));
                continue;
            }
            D.subDiagonal(-i).set(pd.get(i));
        }
        return D;
    }

    public double[] process(IReadDataBlock highSeries, IReadDataBlock lowSeries) {
        DataBlock x = new DataBlock(highSeries);
        DataBlock y = new DataBlock(lowSeries);
        if (this.type_ == TsAggregationType.Average) {
            y.mul(this.conv_);
        }
        int n = x.getLength();
        int ny = y.getLength();
        double xm = x.sum() / (double)x.getLength();
        x.mul(1.0 / xm);
        Matrix D = this.D(x);
        Matrix A = new Matrix(n + ny, n + ny);
        SymmetricMatrix.XtX(D.subMatrix(), A.subMatrix(0, n, 0, n));
        this.J(A.subMatrix(n, n + ny, 0, n));
        Matrix B = A.clone();
        this.J(A.subMatrix(0, n, n, n + ny).transpose());
        B.diagonal().drop(n, 0).set(1.0);
        DataBlock q = new DataBlock(n + ny);
        DataBlock q0 = q.range(0, n);
        q0.copy(x);
        DataBlock q1 = q.range(n, n + ny);
        q1.product(A.subMatrix(n, n + ny, 0, n).rows(), q0);
        q1.chs();
        q1.addAY(1.0 / xm, y);
        DataBlock z = new DataBlock(n + ny);
        z.product(B.rows(), q);
        Householder qr = new Householder(true);
        qr.decompose(A);
        qr.solve(z, q);
        DataBlock rslt = q.range(0, n).deepClone();
        rslt.mul(xm);
        return rslt.getData();
    }

    public double[] process(IReadDataBlock lowSeries) {
        int ny = lowSeries.getLength();
        int n = ny * this.conv_;
        DataBlock x = new DataBlock(n);
        DataBlock y = new DataBlock(lowSeries);
        if (this.type_ == TsAggregationType.Average) {
            y.mul(this.conv_);
        }
        if (this.mul_) {
            x.set(1.0);
        }
        Matrix D = this.D(x);
        Matrix A = new Matrix(n + ny, n + ny);
        SymmetricMatrix.XtX(D.subMatrix(), A.subMatrix(0, n, 0, n));
        this.J(A.subMatrix(n, n + ny, 0, n));
        Matrix B = A.clone();
        this.J(A.subMatrix(0, n, n, n + ny).transpose());
        B.diagonal().drop(n, 0).set(1.0);
        DataBlock q = new DataBlock(n + ny);
        DataBlock q1 = q.range(n, n + ny);
        q1.copy(y);
        DataBlock z = new DataBlock(n + ny);
        z.product(B.rows(), q);
        Householder qr = new Householder(true);
        qr.decompose(A);
        qr.solve(z, q);
        DataBlock rslt = q.range(0, n).deepClone();
        return rslt.getData();
    }

    public boolean isMultiplicative() {
        return this.mul_;
    }

    public void setMultiplicative(boolean mul) {
        this.mul_ = mul;
    }

    public boolean isModifiedDenton() {
        return this.mod_;
    }

    public void setModifiedDenton(boolean mod) {
        this.mod_ = mod;
    }

    public int getConversionFactor() {
        return this.conv_;
    }

    public void setConversionFactor(int factor) {
        this.conv_ = factor;
    }

    public int getDifferencingOrder() {
        return this.diff_;
    }

    public void setDifferencingOrder(int diff) {
        this.diff_ = diff;
    }

    public TsAggregationType getAggregationType() {
        return this.type_;
    }

    public void setAggregationType(TsAggregationType type) {
        this.type_ = type;
    }

    public int getOffset() {
        return this.offset_;
    }

    public void setOffset(int offset) {
        this.offset_ = offset;
    }
}

