/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.integration.r;

import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.zaxxer.sparsebits.SparseBitSet;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.IntStream;

public final class RDataFrameWrapper {
    final DataFrame dataFrame;

    public RDataFrameWrapper() {
        this.dataFrame = new DataFrame();
    }

    public RDataFrameWrapper(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
    }

    public void addNumericColumn(String name, double[] column, boolean[] na) {
        this.dataFrame.addColumn(name, new Column(column, column.length, RDataFrameWrapper.toBitSet(na), DataType.Numeric));
    }

    public void addBooleanColumn(String name, boolean[] column, boolean[] na) {
        this.dataFrame.addColumn(name, new Column(column, column.length, RDataFrameWrapper.toBitSet(na), DataType.Boolean));
    }

    public void addStringColumn(String name, String[] column, boolean[] na) {
        this.dataFrame.addColumn(name, new Column(column, column.length, RDataFrameWrapper.toBitSet(na), DataType.String));
    }

    public void addDateTimeColumn(String name, long[] column, boolean[] na) {
        Date[] elements = (Date[])IntStream.range(0, column.length).mapToObj(i -> na[i] ? null : new Date(column[i])).toArray(Date[]::new);
        this.dataFrame.addColumn(name, new Column(elements, column.length, RDataFrameWrapper.toBitSet(na), DataType.DateTime));
    }

    public String[] getColumnTypes() {
        return (String[])this.dataFrame.getColumnTypes().stream().map(Enum::toString).toArray(String[]::new);
    }

    public String[] getColumnNames() {
        return this.dataFrame.getColumnNames().toArray(new String[0]);
    }

    public double[] getNumericColumn(int col) {
        return this.dataFrame.getColumn(col).getNumericData();
    }

    public String[] getStringColumn(int col) {
        return this.dataFrame.getColumn(col).getStringData();
    }

    public boolean[] getBooleanColumn(int col) {
        return this.dataFrame.getColumn(col).getBooleanData();
    }

    public long[] getDateTimeColumn(int col) {
        return Arrays.stream(this.dataFrame.getColumn(col).getDateTimeData()).mapToLong(date -> date == null ? 0L : date.getTime()).toArray();
    }

    public boolean[] isMissing(int col) {
        Column column = this.dataFrame.getColumn(col);
        SparseBitSet missing = column.getMissing();
        boolean[] na = new boolean[column.size()];
        int i = missing.nextSetBit(0);
        while (i >= 0) {
            na[i] = true;
            i = missing.nextSetBit(i + 1);
        }
        return na;
    }

    private static SparseBitSet toBitSet(boolean[] bits) {
        SparseBitSet bs = new SparseBitSet(bits.length);
        for (int i = 0; i < bits.length; ++i) {
            bs.set(i, bits[i]);
        }
        return bs;
    }
}

