/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.intarray;

import net.sf.jclec.IConfigure;
import net.sf.jclec.intarray.AbstractIntArraySpecies;
import net.sf.jclec.intarray.IntArrayIndividual;
import net.sf.jclec.util.intset.IIntegerSet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayIndividualSpecies
extends AbstractIntArraySpecies<IntArrayIndividual>
implements IConfigure {
    private static final long serialVersionUID = 577795667519852596L;

    public IntArrayIndividualSpecies() {
    }

    public IntArrayIndividualSpecies(IIntegerSet[] genotypeSchema) {
        this.setGenotypeSchema(genotypeSchema);
    }

    public void setGenotypeSchema(IIntegerSet[] genotypeSchema) {
        this.genotypeSchema = genotypeSchema;
    }

    @Override
    public IntArrayIndividual createIndividual() {
        return new IntArrayIndividual();
    }

    @Override
    public IntArrayIndividual createIndividual(int[] genotype) {
        return new IntArrayIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        int genotypeLength = settings.getList("genotype-schema.locus[@type]").size();
        IIntegerSet[] genotypeSchema = new IIntegerSet[genotypeLength];
        int i = 0;
        while (i < genotypeLength) {
            String componentClassname = settings.getString("genotype-schema.locus(" + i + ")[@type]");
            try {
                Class<?> componentClass = Class.forName(componentClassname);
                genotypeSchema[i] = (IIntegerSet)componentClass.newInstance();
                if (genotypeSchema[i] instanceof IConfigure) {
                    ((IConfigure)((Object)genotypeSchema[i])).configure(settings.subset("genotype-schema.locus(" + i + ")"));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            ++i;
        }
        this.setGenotypeSchema(genotypeSchema);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("schema", this.genotypeSchema);
        return tsb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof IntArrayIndividualSpecies) {
            EqualsBuilder eb = new EqualsBuilder();
            IntArrayIndividualSpecies iaoth = (IntArrayIndividualSpecies)other;
            eb.append(this.genotypeSchema, iaoth.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

