/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.MatchOrBind;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetBunch
implements TripleBunch {
    protected Set elements = new HashSet(20);

    public SetBunch(TripleBunch b) {
        ExtendedIterator it = b.iterator();
        while (it.hasNext()) {
            this.elements.add(it.next());
        }
    }

    protected static boolean equalsObjectOK(Triple t) {
        Node o = t.getObject();
        return o.isLiteral() ? o.getLiteralDatatype() == null : true;
    }

    public boolean contains(Triple t) {
        return this.elements.contains(t);
    }

    public boolean containsBySameValueAs(Triple t) {
        return SetBunch.equalsObjectOK(t) ? this.elements.contains(t) : this.slowContains(t);
    }

    protected boolean slowContains(Triple t) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            if (!t.matches((Triple)it.next())) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.elements.size();
    }

    public void add(Triple t) {
        this.elements.add(t);
    }

    public void remove(Triple t) {
        this.elements.remove(t);
    }

    public ExtendedIterator iterator() {
        return WrappedIterator.create(this.elements.iterator());
    }

    public void app(Domain d, StageElement next, MatchOrBind s) {
        ExtendedIterator it = this.iterator();
        while (it.hasNext()) {
            if (!s.matches((Triple)it.next())) continue;
            next.run(d);
        }
    }
}

