/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.DefaultTreeModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class RLCNarrowExchangeOperator
extends SimpleMCMCOperator {
    public static final String NARROW_EXCHANGE = "narrowExchangeRLC";
    private static final int MAX_TRIES = 10000;
    private final DefaultTreeModel tree;
    public static XMLObjectParser NARROW_EXCHANGE_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(DefaultTreeModel.class)};

        @Override
        public String getParserName() {
            return RLCNarrowExchangeOperator.NARROW_EXCHANGE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)xMLObject.getChild(DefaultTreeModel.class);
            double d = xMLObject.getDoubleAttribute("weight");
            return new RLCNarrowExchangeOperator(defaultTreeModel, d);
        }

        @Override
        public String getParserDescription() {
            return "This element represents a narrow exchange operator. This operator swaps a random subtree with its uncle.";
        }

        @Override
        public Class getReturnType() {
            return RLCNarrowExchangeOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public RLCNarrowExchangeOperator(DefaultTreeModel defaultTreeModel, double d) {
        this.tree = defaultTreeModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        int n = this.tree.getExternalNodeCount();
        this.narrow();
        if (this.tree.getExternalNodeCount() != n) {
            throw new RuntimeException("Lost some tips in narrow exchange RLC");
        }
        return 0.0;
    }

    public void narrow() {
        int n = this.tree.getNodeCount();
        NodeRef nodeRef = this.tree.getRoot();
        for (int i = 0; i < 10000; ++i) {
            NodeRef nodeRef2 = this.tree.getNode(MathUtils.nextInt(n));
            while (nodeRef == nodeRef2 || this.tree.getParent(nodeRef2) == nodeRef) {
                nodeRef2 = this.tree.getNode(MathUtils.nextInt(n));
            }
            NodeRef nodeRef3 = this.tree.getParent(nodeRef2);
            NodeRef nodeRef4 = this.tree.getParent(nodeRef3);
            NodeRef nodeRef5 = this.tree.getChild(nodeRef4, 0);
            if (nodeRef5 == nodeRef3) {
                nodeRef5 = this.tree.getChild(nodeRef4, 1);
            }
            assert (this.tree.getNodeHeight(nodeRef2) < this.tree.getNodeHeight(nodeRef4));
            if (!(this.tree.getNodeHeight(nodeRef5) < this.tree.getNodeHeight(nodeRef3))) continue;
            NodeRef nodeRef6 = this.tree.getChild(nodeRef3, 0);
            if (nodeRef6 == nodeRef2) {
                nodeRef6 = this.tree.getChild(nodeRef3, 1);
            }
            this.eupdate(nodeRef2, nodeRef5, nodeRef3, nodeRef4, nodeRef6);
            this.tree.pushTreeChangedEvent(nodeRef3);
            this.tree.pushTreeChangedEvent(nodeRef4);
            return;
        }
        throw new RuntimeException("Couldn't find valid narrow move on this tree!!");
    }

    @Override
    public String getOperatorName() {
        return "Narrow Exchange RLC";
    }

    private void eupdate(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3, NodeRef nodeRef4, NodeRef nodeRef5) {
        this.tree.beginTreeEdit();
        this.tree.removeChild(nodeRef3, nodeRef);
        this.tree.removeChild(nodeRef4, nodeRef2);
        this.tree.addChild(nodeRef4, nodeRef);
        this.tree.addChild(nodeRef3, nodeRef2);
        this.tree.endTreeEdit();
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        arrayList.add(nodeRef);
        arrayList.add(nodeRef3);
        arrayList.add(nodeRef2);
        arrayList.add(nodeRef4);
        arrayList.add(nodeRef5);
        NodeRef nodeRef6 = (NodeRef)arrayList.remove(MathUtils.nextInt(arrayList.size()));
        NodeRef nodeRef7 = (NodeRef)arrayList.get(MathUtils.nextInt(arrayList.size()));
        double d = this.tree.getNodeTrait(nodeRef6, "trait");
        double d2 = this.tree.getNodeTrait(nodeRef6, "trait");
        this.tree.setNodeTrait(nodeRef6, "trait", d2);
        this.tree.setNodeTrait(nodeRef7, "trait", d);
    }
}

