/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.complex;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.ComplexList;
import dmLab.classifier.adx.complex.Quality;
import dmLab.classifier.adx.selector.Selector;
import dmLab.classifier.adx.selector.SelectorList;
import dmLab.utils.ArrayUtils;
import dmLab.utils.GeneralUtils;
import dmLab.utils.list.IntegerList;
import java.util.Arrays;
import java.util.HashMap;

public final class ComplexSet {
    private ComplexList complexesList;
    private int complexSize;
    private HashMap<Integer, Integer> positionBySelectorId;
    private ADXParams cfg;
    public boolean verbose = false;

    public ComplexSet(SelectorList selectorsList, ADXParams adxParams, int attrNumber) {
        this.complexSize = 1;
        this.cfg = adxParams;
        this.complexesList = new ComplexList();
        int[] tempArray = new int[1];
        int selectorsListSize = selectorsList.size();
        int i = 0;
        while (i < selectorsListSize) {
            Selector tmpSelector = selectorsList.getSelector(i);
            tempArray[0] = i++;
            Complex tmpComplex = new Complex(tempArray);
            new Complex(tempArray).coverage = tmpSelector.coverage;
            tmpComplex.posCoverage = tmpSelector.posCoverage;
            tmpComplex.negCoverage = tmpSelector.negCoverage;
            tmpComplex.posSupport = tmpSelector.posSupport;
            tmpComplex.negSupport = tmpSelector.negSupport;
            tmpComplex.prepareToCoversFast(selectorsList, attrNumber);
            this.complexesList.add(tmpComplex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ComplexSet(SelectorList selectorsList, ComplexSet prevComplexList, ADXParams params, int attrNumber) {
        int n;
        boolean bl;
        ComplexSet complexSet;
        void var2_2;
        void var3_3;
        this.cfg = var3_3;
        if (prevComplexList.size() > this.cfg.searchBeam) {
            prevComplexList.findSignificantQuality();
        }
        int n2 = attrNumber;
        var3_3 = var2_2;
        var2_2 = complexSet;
        complexSet = this;
        void var7_5 = var3_3;
        this.complexSize = var7_5.complexSize + 1;
        complexSet.complexesList = new ComplexList();
        int[] nArray = new int[complexSet.complexSize];
        int n3 = var3_3.complexesList.size();
        var7_5 = var3_3;
        int n4 = var7_5.complexSize;
        if (complexSet.complexSize == 2) {
            for (int i = 0; i < n3; ++i) {
                Complex complex = var3_3.getComplex(i);
                if (!complex.reproduce) continue;
                for (int j = i + 1; j < n3; ++j) {
                    Complex complex2 = var3_3.getComplex(j);
                    if (!complex2.reproduce || complex.equalAttributes(complex2, (SelectorList)var2_2)) continue;
                    for (int k = 0; k < n4; ++k) {
                        nArray[k] = complex.getSelectorId(k);
                    }
                    nArray[nArray.length - 1] = complex2.getSelectorId(n4 - 1);
                    Complex complex3 = new Complex(nArray);
                    complex3.setParentsCovs(complex.posCoverage, complex.negCoverage, complex2.posCoverage, complex2.negCoverage);
                    complex3.prepareToCoversFast((SelectorList)var2_2, n2);
                    complexSet.complexesList.add(complex3);
                }
            }
            return;
        }
        void var8_10 = var3_3;
        if (var8_10.complexSize < 2) {
            bl = false;
        } else {
            int n5 = var8_10.complexesList.size();
            var8_10.positionBySelectorId = new HashMap();
            int n6 = -1;
            for (n = 0; n < n5; ++n) {
                int n7 = var8_10.complexesList.get(n).getSelectorId(0);
                if (n7 == n6) continue;
                var8_10.positionBySelectorId.put(n7, n);
                n6 = n7;
            }
            bl = true;
        }
        for (int i = 0; i < n3; ++i) {
            Object object;
            Complex complex = var3_3.getComplex(i);
            if (!complex.reproduce || (object = var3_3.positionBySelectorId.get(complex.idSelectors[1])) == null) continue;
            n = (Integer)object;
            Complex complex4 = var3_3.getComplex(n);
            while (complex4 != null && complex.idSelectors[1] == complex4.idSelectors[0]) {
                if (complex4.reproduce && complex.containsSubsequence(complex4)) {
                    for (int j = 0; j < n4; ++j) {
                        nArray[j] = complex.getSelectorId(j);
                    }
                    nArray[nArray.length - 1] = complex4.getSelectorId(n4 - 1);
                    object = new Complex(nArray);
                    ((Complex)object).setParentsCovs(complex.posCoverage, complex.negCoverage, complex4.posCoverage, complex4.negCoverage);
                    ((Complex)object).prepareToCoversFast((SelectorList)var2_2, n2);
                    complexSet.complexesList.add((Complex)object);
                }
                complex4 = var3_3.getComplex(++n);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Complex getComplex(int index) {
        void var1_1;
        return this.complexesList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeComplex(int index) {
        void var1_1;
        this.complexesList.remove((int)var1_1);
    }

    public final int size() {
        if (this.complexesList != null) {
            return this.complexesList.size();
        }
        return 0;
    }

    public final boolean trimList() {
        return this.complexesList.trim();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(SelectorList selectorsList, FArray array) {
        void var3_3;
        StringBuffer tmp = new StringBuffer();
        tmp.append("#Complex Size: " + this.complexSize).append('\n');
        tmp.append("#Complexes Number: " + this.complexesList.size()).append('\n');
        int complexesListSize = this.complexesList.size();
        for (int i = 0; i < complexesListSize; ++i) {
            Complex tmpComplex = this.complexesList.get(i);
            StringBuilder stringBuilder = new StringBuilder(" ").append(tmpComplex.toString(selectorsList, array)).append('\t');
            Complex complex = tmpComplex;
            Object object = new StringBuffer();
            ((StringBuffer)object).append("p: " + GeneralUtils.formatFloat(complex.posCoverage, 3));
            ((StringBuffer)object).append(" n: " + GeneralUtils.formatFloat(complex.negCoverage, 3));
            ((StringBuffer)object).append(" c: " + GeneralUtils.formatFloat(complex.coverage, 3));
            ((StringBuffer)object).append(" ps: " + GeneralUtils.formatFloat(complex.posSupport, 3));
            ((StringBuffer)object).append(" ns: " + GeneralUtils.formatFloat(complex.negSupport, 3));
            tmp.append(stringBuilder.append(((StringBuffer)object).toString()).toString());
            StringBuilder stringBuilder2 = new StringBuilder(" ");
            object = this.cfg;
            complex = tmpComplex;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("q: " + GeneralUtils.formatFloat(complex.calcQuality(((ADXParams)object).qMethod), 4));
            stringBuffer.append(" qf: " + GeneralUtils.formatFloat(complex.calcQuality(((ADXParams)object).qMethodFinal), 4));
            tmp.append(stringBuilder2.append(stringBuffer.toString()).toString());
            StringBuilder stringBuilder3 = new StringBuilder(" ");
            complex = tmpComplex;
            object = new StringBuffer();
            ((StringBuffer)object).append("pr: " + GeneralUtils.formatFloat(complex.calcPosProbability(), 4));
            tmp.append(stringBuilder3.append(((StringBuffer)object).toString()).toString());
            tmp.append('\n');
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        int complexListSize = this.complexesList.size();
        for (int i = 0; i < complexListSize; ++i) {
            int j = 0;
            while (j < this.complexSize) {
                int n = j++;
                int n2 = i;
                ComplexSet complexSet = this;
                tmp.append(" " + complexSet.complexesList.get(n2).getSelectorId(n));
            }
            tmp.append('\n');
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean evaluate$1594a9c8(FArray array, int decisionValIndex) {
        int interval;
        if (this.complexesList.size() == 0) {
            return false;
        }
        int eventsNumber = ((Array)array).rowsNumber();
        int complexesListSize = this.complexesList.size();
        float complexesListSizeDbl = this.complexesList.size();
        int decAttrIndex = array.getDecAttrIdx();
        float decisionValue = array.getDecValues()[decisionValIndex];
        int threshold = interval = (int)Math.ceil(0.1 * (double)complexesListSize);
        int totalPos = array.getADXDomain(decAttrIndex).getTotalPositives(decisionValIndex);
        int totalNeg = array.getADXDomain(decAttrIndex).getTotalNegatives(decisionValIndex);
        if (this.verbose) {
            System.out.print("Progress: ");
        }
        for (int i = 0; i < complexesListSize; ++i) {
            void var3_13;
            void var2_2;
            int complexPosSupport = 0;
            int complexNegSupport = 0;
            Complex complex = this.complexesList.get(i);
            for (int j = 0; j < eventsNumber; ++j) {
                if (!complex.coversFast(array, j)) continue;
                if (array.readValue(decAttrIndex, j) == decisionValue) {
                    ++complexPosSupport;
                    continue;
                }
                ++complexNegSupport;
            }
            complex.posCoverage = (float)complexPosSupport / (float)totalPos;
            complex.negCoverage = (float)complexNegSupport / (float)totalNeg;
            complex.coverage = (float)(complexPosSupport + complexNegSupport) / (float)eventsNumber;
            complex.posSupport = (float)var2_2;
            complex.negSupport = (float)var3_13;
            if (i <= threshold || threshold == 0) continue;
            if (this.verbose) {
                System.out.print((int)(100.0 * (double)i / (double)complexesListSizeDbl) + "% ");
            }
            threshold += interval;
        }
        if (this.verbose) {
            System.out.println("100% ");
        }
        return true;
    }

    public final int cleanCandidatesSet(SelectorList selectorsList, ADXParams adxParams) {
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        for (int i = 0; i < listSize; ++i) {
            Complex complex = this.complexesList.get(i);
            if ((double)complex.posCoverage == 0.0) {
                this.complexesList.remove(i);
                ++removed;
                continue;
            }
            if (adxParams.cleanCandidates == 1) {
                if (complex.betterThanSubSelectors_Q(selectorsList, this.cfg.qMethod)) continue;
                this.complexesList.remove(i);
                ++removed;
                continue;
            }
            if (adxParams.cleanCandidates != 2 || complex.betterThanParents_Q(this.cfg.qMethod)) continue;
            this.complexesList.remove(i);
            ++removed;
        }
        this.complexesList.trim();
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesPosLessNeg() {
        void var2_2;
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        for (int i = 0; i < listSize; ++i) {
            Complex complex;
            Complex complex2 = this.complexesList.get(i);
            if (!(complex.posCoverage <= complex2.negCoverage)) continue;
            this.complexesList.remove(i);
            ++removed;
        }
        this.complexesList.trim();
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesCoversNeg() {
        void var2_2;
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        for (int i = 0; i < listSize; ++i) {
            if (!((double)this.complexesList.get((int)i).negCoverage > 0.0)) continue;
            this.complexesList.remove(i);
            ++removed;
        }
        this.complexesList.trim();
        return (int)var2_2;
    }

    public final int deleteComplexesQLess(double minQuality) {
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        for (int i = 0; i < listSize; ++i) {
            if (!(this.getComplex(i).calcQuality(this.cfg.qMethod) < minQuality)) continue;
            this.complexesList.remove(i);
            ++removed;
        }
        this.complexesList.trim();
        return removed;
    }

    public final int selectComplexesToReproduce(double minQuality) {
        int listSize = this.complexesList.size();
        int toReproduce = 0;
        IntegerList minQualityIDs = new IntegerList();
        for (int i = 0; i < listSize; ++i) {
            Complex complex = this.complexesList.get(i);
            double complexQuality = complex.calcQuality(this.cfg.qMethod);
            if ((this.cfg.complexGenerality != 1 || (double)complex.negCoverage != 0.0) && complexQuality >= minQuality) {
                complex.reproduce = true;
                ++toReproduce;
                if (complexQuality != minQuality) continue;
                minQualityIDs.add(i);
                continue;
            }
            complex.reproduce = false;
        }
        if (toReproduce > this.cfg.searchBeam) {
            int toThrow = toReproduce - this.cfg.searchBeam;
            int[] throwArray = new int[minQualityIDs.size()];
            ArrayUtils arrayUtils = new ArrayUtils();
            arrayUtils.randomSelect(throwArray, toThrow, 1, 0);
            for (int i = 0; i < throwArray.length; ++i) {
                if (throwArray[i] != 1) continue;
                this.complexesList.get((int)minQualityIDs.get((int)i)).reproduce = false;
                --toReproduce;
            }
        }
        return toReproduce;
    }

    /*
     * WARNING - void declaration
     */
    public final double findSignificantQuality() {
        void var2_2;
        void var1_1;
        double[] significantQ = new double[this.cfg.searchBeam];
        Arrays.fill(significantQ, Double.NEGATIVE_INFINITY);
        int minValuePosition = significantQ.length;
        int listSize = this.complexesList.size();
        for (int i = 0; i < listSize; ++i) {
            Complex complex = this.complexesList.get(i);
            if (!complex.reproduce) continue;
            double complexQuality = complex.calcQuality(this.cfg.qMethod);
            if (minValuePosition > 0) {
                significantQ[--minValuePosition] = complexQuality;
                continue;
            }
            if (!(complexQuality >= significantQ[0])) continue;
            significantQ[0] = complexQuality;
            Arrays.sort(significantQ);
        }
        Arrays.sort(significantQ);
        if (minValuePosition >= significantQ.length) {
            System.out.println("significantQ: " + Arrays.toString(significantQ));
            return Double.NEGATIVE_INFINITY;
        }
        return (double)var1_1[var2_2];
    }

    /*
     * Unable to fully structure code
     */
    public final boolean mergeComplexes(SelectorList selectorsList, FArray array) {
        listSize = this.complexesList.size();
        currentIndex = 0;
        if (listSize == 0) {
            return false;
        }
        i = 0;
        while (i < listSize - 1) {
            complex = this.complexesList.get(i);
            if (complex == null) {
                ++i;
                continue;
            }
            for (stopIndex = i + 1; stopIndex < listSize && complex.mergingPossible(selectorsList, this.complexesList.get(stopIndex), array); ++stopIndex) {
                block12: {
                    block11: {
                        var9_9 = this.cfg;
                        var8_8 = this.complexesList.get(stopIndex);
                        var7_7 = complex;
                        if (var9_9.mergeCondition == 0) ** GOTO lbl-1000
                        if (var9_9.mergeCondition != 1) break block11;
                        v0 = true;
                        break block12;
                    }
                    if (var9_9.mergeCondition != 2) ** GOTO lbl-1000
                    var11_10 = Quality.calc(var7_7.posCoverage, var7_7.negCoverage, var9_9.qMethod);
                    var13_11 = Quality.calc(var8_8.posCoverage, var8_8.negCoverage, var9_9.qMethod);
                    var15_12 = Quality.calc(var7_7.posCoverage + var8_8.posCoverage, var7_7.negCoverage + var8_8.negCoverage, var9_9.qMethod);
                    if (var15_12 > var11_10 || var15_12 > var13_11) {
                        v0 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v0 = false;
                    }
                }
                if (!v0) break;
            }
            if (currentIndex < stopIndex) {
                ++currentIndex;
            }
            while (currentIndex < stopIndex) {
                if (complex.merge(selectorsList, this.getComplex(currentIndex), array)) {
                    this.removeComplex(currentIndex++);
                    continue;
                }
                if (complex.contains(selectorsList, this.getComplex(currentIndex), array)) {
                    this.removeComplex(currentIndex);
                } else {
                    System.err.println("Error. Complexes have not been merged.\n\t" + complex.toString(selectorsList, array) + "\n\t" + this.getComplex(currentIndex).toString(selectorsList, array));
                }
                ++currentIndex;
            }
            var5_5 = stopIndex;
        }
        this.complexesList.trim();
        return true;
    }
}

