/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.graph;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.view.GraphView;
import org.chocosolver.util.objects.graphs.UndirectedGraph;

public abstract class UndirectedGraphView<V extends Variable>
extends GraphView<V, UndirectedGraph>
implements UndirectedGraphVar {
    protected UndirectedGraphView(String name, V[] variables) {
        super(name, variables);
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public boolean removeNode(int node, ICause cause) throws ContradictionException {
        assert (cause != null);
        assert (node >= 0 && node < this.getNbMaxNodes());
        if (this.getMandatoryNodes().contains(node)) {
            this.contradiction(cause, "remove mandatory node");
            return false;
        }
        if (!this.getPotentialNodes().contains(node)) {
            return false;
        }
        int neiSize = this.getPotentialNeighborsOf(node).size();
        if (this.doRemoveNode(node)) {
            if (neiSize > 0) {
                this.notifyPropagators(GraphEventType.REMOVE_EDGE, cause);
            }
            this.notifyPropagators(GraphEventType.REMOVE_NODE, cause);
            return true;
        }
        return false;
    }
}

