/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public final class DefaultColumnBuilder
extends ColumnBuilder {
    private final List<Object> missingValueStrings;
    private final List<Object> missingValueNumbers;

    public DefaultColumnBuilder(int nrows, boolean forceConversion, boolean takeCached, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, Object[] missingValue, String dateTimeFormat) {
        super(nrows, forceConversion, takeCached, evaluator, onErrorCell, dateTimeFormat);
        Map<Boolean, List<Object>> partitioned = Arrays.stream(missingValue).collect(Collectors.partitioningBy(o -> o instanceof String));
        this.missingValueStrings = partitioned.get(true);
        this.missingValueNumbers = partitioned.get(false);
    }

    @Override
    protected void handleCell(Cell c, CellValue cv) {
        switch (cv.getCellType()) {
            case BLANK: {
                this.addMissing();
                break;
            }
            case BOOLEAN: {
                this.addValue(c, cv, DataType.Boolean);
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)c)) {
                    this.addValue(c, cv, DataType.DateTime);
                    break;
                }
                double value = cv.getNumberValue();
                if (this.missingValueNumbers.contains(value)) {
                    this.addMissing();
                    break;
                }
                this.addValue(c, cv, DataType.Numeric);
                break;
            }
            case STRING: {
                String value = cv.getStringValue();
                if (value == null || this.missingValueStrings.contains(value)) {
                    this.addMissing();
                    break;
                }
                this.addValue(c, cv, DataType.String);
                break;
            }
            case FORMULA: {
                this.cellError("Formula detected in already evaluated cell " + CellUtils.formatAsString(c) + "!");
                break;
            }
            case ERROR: {
                this.cellError("Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(cv.getErrorValue()));
                break;
            }
            default: {
                this.cellError("Unexpected cell type detected for cell " + CellUtils.formatAsString(c) + "!");
            }
        }
    }
}

